// Brutal Chess
//
// File : brutalchessconsole.cpp
// Date : 05/03/2005
// Authors : Maxwell Lazaroff and Michael Cook
//
// Description : Driver file for the game.

#include<iostream>
#include "board.h"
#include "boardmove.h"
#include "chessplayer.h"
#include "alphabetaplayer.h"
#include "humanplayer.h"
using namespace std;

/***************************************************************************
*	Error Codes
***************************************************************************/

const int NOERR = 0;

void 
printBanner(){
	cout << endl;
	cout << "=======================================================\n";
	cout << "                Welcome To Brutal Chess                \n";
	cout << "=======================================================\n";

	return;
}

bool
askToQuit(){
	
	string userResponse;
	const string YES = "yes";
	const string NO  = "no";
	
	cout << "Would you like to quit? [yes/no]: ";
	cin >> userResponse;
	
	if (userResponse == YES){
		return true;
	} else if (userResponse == NO){
		return false;
	} else{
		cout << "Please type 'yes' or 'no'...\n";
		return askToQuit();
	}
}

void
usage(){

    cout << "==========================================================" <<endl;
    cout << "                   BRUTAL CHESS USAGE                     " <<endl;
    cout << "==========================================================" <<endl;
    cout << "                                                          " <<endl;
    cout << " ./brutalchessconsole <Player 1 (W)> <Player 2 (B)> <First Move>";
	cout << endl;
    cout << "                                                          " <<endl;
    cout << " <Player1 (W)> - Enter either your name or the type of    " <<endl;
    cout << "                 AI (AI TYPES HERE) you wish to play.     " <<endl;
    cout << " <Player2 (B)> - Use exactly as the <Player1 (W)> option. " <<endl;
    cout << " <FirstMove>   - Enter either 'W' or 'B', whoever you wish" <<endl;
    cout << "                 to have the first move                   " <<endl;
    cout << "                                                          " <<endl;
    cout << "==========================================================" <<endl;
}

    
	
	
/***************************************************************************
*	Main
***************************************************************************/

int 
main(int argc, char *argv[]){

    if(argc != 4)
    {
        usage();
        return 1;
    }

    ChessPlayer * _playOne = new HumanPlayer(argv[1]);
    ChessPlayer * _playTwo = new AlphaBetaPlayer;


    
    if(_playOne->getName() == _playTwo->getName())
    {
      _playOne->append_name("_1");
      _playTwo->append_name("_2");
    }

	printBanner();

	bool quitGame   = false;
	bool gameOver   = false;
	int  roundCount = 2;
	bool player     = true; // True == White's turn
	
	if(argv[3] == "B")
	   player = false;
	
	Board board;
	
	BoardMove currentmove;
	
	while (!quitGame){
		// Loops while the user has not quit Brutal Chess.
		cout << "Starting a new game.\n";
		
		while (!gameOver){
			board.print();
			cout << "Brutal Chess!" << endl << _playOne->getName();
			cout << "(white) VERSUS ";
			cout << _playTwo->getName() << "(black), on round ";
			cout << roundCount/2 <<endl;
			
			if(player)
            {
                cout << _playOne->getName() << "'s move..." << endl;
                currentmove = (*_playOne).decide_move(board, player);
            }
			if(!player)
			{
				cout << _playTwo->getName() << "'s move..." << endl;
				currentmove = (*_playTwo).decide_move(board, player);
			}
			
			cout << currentmove;
			board.updateBoard(currentmove);
			
			if(player)
			{
                if((*_playTwo).inCheckmate(board, player))
                {
                    cout << endl;
                    cout << _playTwo->getName() << " is in checkmate!" << endl;
                    cout << _playOne->getName() << " wins the game!" << endl;
                    gameOver = true;
                }
            }
            else
			{
                if((*_playOne).inCheckmate(board, player))
                {
                    cout << endl;
                    cout << _playOne->getName() << " is in checkmate!" << endl;
                    cout << _playTwo->getName() << " wins the game!" << endl;
                    gameOver = true;
                }
            }
						
			roundCount++;
			player = !player;
		}
		
		// Asks the user to quit, or to play another game.
		quitGame = askToQuit();
	}

	return NOERR;
}

// End of file brutalchessconsole.cpp
