
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include "brighton.h"
#include "bristol.h"

extern void cleanupBristol();

extern int bristolMidiSendMsg();
extern int destroySynth(int);

typedef int (*synthRoutine)(void *, int, int, int, int, int);

typedef struct miniDispatch {
	int controller;
	int operator;
	int other1;
	int other2;
	synthRoutine routine;
} dispatcher;

typedef struct Memory {
	char algo[32];
	char name[32];
	int count;
	int active;
	float *param;
} memory;

#define BRISTOL_NOCALLS 0x01
#define BRISTOL_STAT 0x02
#define C_RANGE_MIN_1 (CONTROLLER_RANGE - 1)

#define OPERATIONAL 0x01
#define BANK_SELECT 0x02
#define MEM_LOADING 0x04
#define SUPPRESS 0x08
typedef struct GuiSynth {
	struct GuiSynth *next, *last;
	unsigned int flags;
	char name[32];
	int sid;
	int sid2; // for GUIs with dual manual connections.
	int midichannel;
	int synthtype;
	int voices;
	int connid;
	int bank;
	int location;
	int panel;
	int transpose;
	memory mem;
	brightonApp *resources;
	dispatcher *dispatch;
	struct guiSynth *lower; // Dual manual keyboards
	struct guimain *manual; // Dual manual keyboards
} guiSynth;

#define BRIGHTON_NOENGINE 0x80000000
typedef struct guiMain {
	unsigned int flags;
	char *home;
	int controlfd;
	int enginePID;
	int libtest;
	int voices;
	guiSynth *synths;
	int port;
} guimain;

extern guiSynth *findSynth(guiSynth *, int);
extern int loadMemory(guiSynth *, char *, char *,  int, int, int, int);
extern int saveMemory(guiSynth *, char *, char *, int, int);
extern int displayText(guiSynth *, char *, int, int);
extern int displayPanelText(guiSynth *, char *, int, int, int);

