
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "brightoninternals.h"

/*
 * For now we only have cheap shading - puts a fixed shape of reduced intensity
 * pixels into the shadow layer. nc - 17/04/02.
 */
brightonRenderShadow(brightonDevice *dev, int flags)
{
	register int x, y, pf, py, po = 0, ys, xs, wr = 0;
	register brightonWindow *bwin = dev->bwin;
	register brightonPalette *palette = bwin->display->palette;

//	printf("brightonRenderShadow(%x, %i, %i, %i, %i, %i, %i)\n", dev,
//		dev->x, dev->y, dev->width, dev->height,
//		dev->bwin->app->resources[dev->panel].sx,
//		dev->bwin->app->resources[dev->panel].sy);

	if (dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
		& BRIGHTON_NOSHADOW)
		return;

	if (dev->device == -1)
		return;
	if (dev->device == 0)
	{
		ys = dev->y
			+ dev->bwin->app->resources[dev->panel].sy + dev->height / 2 + 2;
		xs = dev->x + dev->bwin->app->resources[dev->panel].sx;

		for (y = ys; y < ys + dev->height / 2; y++)
		{
			py = y * bwin->slayer->width;

			for (x = xs; x < xs + dev->width - po / 2; x++)
			{
				pf = py + x + po;
				/*
				 * Take whatever is in the canvas area, reduce its brightness,
				 * put that into the shadow area.
				 */
				bwin->slayer->pixels[pf]
					= brightonGetGC(bwin,
						palette[bwin->canvas->pixels[pf]].red / 2,
						palette[bwin->canvas->pixels[pf]].green / 2,
						palette[bwin->canvas->pixels[pf]].blue / 2);
			}
			po++;
		}

		for (; y < ys + dev->height; y++)
		{
			py = y * bwin->slayer->width;

			if (y >= bwin->slayer->height)
				break;

			for (x = xs; x < xs + dev->width - po / 2 - wr; x++)
			{
				if (x >= bwin->slayer->width)
					continue;

				pf = py + x + po;
				/*
				 * Take whatever is in the canvas area, reduce its brightness,
				 * put that into the shadow area.
				 */
				bwin->slayer->pixels[pf]
					= brightonGetGC(bwin,
						palette[bwin->canvas->pixels[pf]].red / 2,
						palette[bwin->canvas->pixels[pf]].green / 2,
						palette[bwin->canvas->pixels[pf]].blue / 2);
			}
			po++;
			wr += 2;
		}
	} else {
		/*
		 * for a brightonScale
		 */
		ys = dev->y + dev->bwin->app->resources[dev->panel].sy
			+ (int) dev->position;
		xs = dev->x + dev->bwin->app->resources[dev->panel].sx;

		for (y = ys; y < ys + dev->height / 4; y++)
		{
			py = y * bwin->slayer->width;

			for (x = xs; x < xs + dev->width + po; x++)
			{
				pf = py + x;
				/*
				 * Take whatever is in the canvas area, reduce its brightness,
				 * put that into the shadow area.
				 */
				if (flags)
					bwin->slayer->pixels[pf] = -1;
				else
					bwin->slayer->pixels[pf]
						= brightonGetGC(bwin,
							palette[bwin->canvas->pixels[pf]].red / 2,
							palette[bwin->canvas->pixels[pf]].green / 2,
							palette[bwin->canvas->pixels[pf]].blue / 2);
			}
			if (po < dev->width / 2)
				po++;
		}

		for (; y < ys + dev->height / 4 + dev->width / 2; y++)
		{
			py = y * bwin->slayer->width;

			for (x = xs; x < xs + dev->width + po - wr; x++)
			{
				pf = py + x + wr;
				/*
				 * Take whatever is in the canvas area, reduce its brightness,
				 * put that into the shadow area.
				 */
				if (flags)
					bwin->slayer->pixels[pf] = -1;
				else
					bwin->slayer->pixels[pf]
						= brightonGetGC(bwin,
							palette[bwin->canvas->pixels[pf]].red / 2,
							palette[bwin->canvas->pixels[pf]].green / 2,
							palette[bwin->canvas->pixels[pf]].blue / 2);
			}
			wr++;
		}
	}
}

