#ifndef _KDEAUDIOCONTENT_H_
#define _KDEAUDIOCONTENT_H_

#include <qframe.h>
#include <qpixmap.h>
#include <qbitmap.h>

#include "prPartEditor.h"
#include "kdeEditorToolBar.h"

class Part;
class QPaintEvent;
class QResizeEvent;
class Event;
class PositionCursor;
class QLineEdit;
class KdeEditorToolBar;
class KdeAudioEditor;


class KdeAudioContent : public QFrame
{
  Q_OBJECT

 private:
  KdeAudioEditor   * _editor;
  KdeEditorToolBar * _toolbar;
  QPopupMenu * rbmenu;
  QCursor * prcursor;
  QWidget          * moveWidget;
  QLineEdit        * _line;
  PositionCursor   * _position_cursor;
  int                _grid_id;
  int                _pressX;
  int                _pressY;
  int                _moveX;
  int                _moveY;
  int                _grabX;
  int                _grabY;
  int                _grabW;
  int                _xoffset;
  int                _yoffset;
  int                _xright;
  int                _height;
  Event            * _grab;
  Event            * _edit;
  Event            * _line_event;
  bool shftFlag;
  bool ctrlFlag;
  bool suprFlag;

  int mouseY(int p=-1);

 public:
  KdeAudioContent( KdeAudioEditor * , KdeEditorToolBar * );
  void moveCursor(long ticks);

 public slots:
  void paintEvent ( QPaintEvent * );
  void mousePressEvent( QMouseEvent * );
  void mouseMoveEvent( QMouseEvent * );
  void mouseReleaseEvent( QMouseEvent * );
  void keyPressEvent( QKeyEvent * );
  void keyReleaseEvent( QKeyEvent * );
  void updateLine();
  void deleteAudioEvent();
  void editFileName();
  void editFile();
};

#endif
