#ifndef _KDEARRANGER_CPP_
#define _KDEARRANGER_CPP_

#include <iostream.h>

#include "klocale.h"

#include "kdeArranger.h"
#include "kdeScoreEditor2.h"
#include "kdePianoRollEditor.h"
#include "kdeScoreTrack.h"
#include "kdeMainEditor.h"

#include "song.h"
#include "track.h"
#include "part.h"
#include "scoreTrack.h"
#include "addElement.h"
#include "prMainEditor.h"
#include "addon.h"

extern Song * sonG;
extern PrMainEditor * mainEditor;

#define ME ((KdeMainEditor*)mainEditor)

KdeArranger::KdeArranger(QWidget * parent, QPopupMenu * userDef)
  : QWidget(parent)
{
  rbmenu = new QPopupMenu;
  rbmenu->connectItem( rbmenu->insertItem(i18n("Edit Pianoroll")), this, SLOT(slotEditPianoRoll()) );
  rbmenu->connectItem( rbmenu->insertItem(i18n("Edit Score")), this, SLOT(slotEditScore()) );
  rbmenu->insertSeparator();
  rbmenu->insertItem(i18n("User Addons"), userDef );
  
}

void KdeArranger::slotAddon(int i) {
  if (ME->actionList()[0] != 0) {
    ME->performAction( i, sonG );
  }
}

void KdeArranger::mousePressEvent(QMouseEvent * mouse) {
  if (mouse->button()==RightButton) {
    rbmenu->popup( mapToGlobal(mouse->pos()), 0 );
  }
}

void KdeArranger::mouseDoubleClickEvent(QMouseEvent * mouse) {
  int xx = mouse->x();
  double pixPerTick = ME->pixPerTick();
  Position pos = Position(ME->barOffset()+1,1,0);
  pos += (xx-20)*1.0/pixPerTick;
  pos.snap(ME->snap());

  int yy = mouse->y()/(1+ME->trackHeight());
  Track * tr = (Track*) sonG->get(yy);
  if (tr==0) {
    tr = new ScoreTrack();
    sonG->doo(new AddElement(tr,sonG));
  }
  Part * pt = new Part(tr);
  pt->setStart(pos);
  sonG->doo(new AddElement(pt,tr));
  pt->reorder();
  ME->update();
}

void KdeArranger::slotEditScore() {
  if (sonG->hasScore()) {
    KdeScoreEditor2 * ev = new KdeScoreEditor2(ME);
    mainEditor->addEditor(ev);
    ev->show();
  }
}

void KdeArranger::slotEditPianoRoll() {
  if (sonG->hasScore()) {
    KdePianoRollEditor * ev = new KdePianoRollEditor();
    mainEditor->addEditor(ev);
    ev->KMainWindow::show();
  }
}

#endif
#include "kdeArranger.moc"
