#ifndef _COMMENTTRACK_CPP_
#define _COMMENTTRACK_CPP_

#include <iostream.h>
#include "commentTrack.h"
#include "loader.h"
#include "table.h"
#include "str.h"
#include "prTrack.h"
#include "prFactory.h"
#include "song.h"

extern Song * sonG;
extern PrFactory * factory;


CommentTrack::CommentTrack()
{
  _type = COMMENTTRACK;
  _pr = factory->createCommentTrack(this);
}

CommentTrack::CommentTrack(const CommentTrack& st)
  : Track(st,COMMENTTRACK)
{
    _pr = factory->createCommentTrack(this);
}

CommentTrack::~CommentTrack() {
}

ostream & CommentTrack::printOptions(int dep, ostream & s) const {
  s << spc(dep) << "<OPTIONS ";
  // TODO...
  s << " />" << endl;
  return s;
}

void CommentTrack::flush(const char * c) const {
  cout << c << "COMMENTTRACK" << endl;
}

Element * CommentTrack::copy() const {
  return new CommentTrack(*this);
}

void CommentTrack::loadOpt(ifstream *& inPtr) {
  Table * opt = Loader::getAttributes("OPTIONS",inPtr);

  opt->scratch();
  delete opt;
}


#endif
