/*************************************************
* PK Key Types Source File                       *
* (C) 1999-2007 Jack Lloyd                       *
*************************************************/

#include <botan/pk_keys.h>
#include <botan/oids.h>

namespace Botan {

/*************************************************
* Default OID access                             *
*************************************************/
OID Public_Key::get_oid() const
   {
   try {
      return OIDS::lookup(algo_name());
      }
   catch(Lookup_Error)
      {
      throw Lookup_Error("PK algo " + algo_name() + " has no defined OIDs");
      }
   }

/*************************************************
* Run checks on a loaded public key              *
*************************************************/
void Public_Key::load_check(RandomNumberGenerator& rng) const
   {
   if(!check_key(rng, BOTAN_PUBLIC_KEY_STRONG_CHECKS_ON_LOAD))
      throw Invalid_Argument(algo_name() + ": Invalid public key");
   }

/*************************************************
* Run checks on a loaded private key             *
*************************************************/
void Private_Key::load_check(RandomNumberGenerator& rng) const
   {
   if(!check_key(rng, BOTAN_PRIVATE_KEY_STRONG_CHECKS_ON_LOAD))
      throw Invalid_Argument(algo_name() + ": Invalid private key");
   }

/*************************************************
* Run checks on a generated private key          *
*************************************************/
void Private_Key::gen_check(RandomNumberGenerator& rng) const
   {
   if(!check_key(rng, BOTAN_PRIVATE_KEY_STRONG_CHECKS_ON_GENERATE))
      throw Self_Test_Failure(algo_name() + " private key generation failed");
   }

}
