//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Sample/LayerForm.h
//! @brief     Defines class LayerForm.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLE_LAYERFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLE_LAYERFORM_H

#include "GUI/View/Widget/GroupBoxes.h"
#include <memory>

class HeinzFormLayout;
class LayerItem;
class ParticleLayoutItem;
class SampleEditorController;
class WidgetMoverButton;

//! Form for editing a layer
class LayerForm : public CollapsibleGroupBox {
    Q_OBJECT
public:
    LayerForm(QWidget* parent, LayerItem* layerItem, SampleEditorController* ec);

    void updateLayerPositionDependentElements();
    void onLayoutAdded(ParticleLayoutItem* t);
    void onAboutToRemoveLayout(ParticleLayoutItem* t);
    LayerItem* layerItem() const { return m_layer; }
    void updateTitle();
    void expand();

private:
    void updateColor();

    HeinzFormLayout* m_layout;
    LayerItem* m_layer;
    QAction* m_duplicate_action;
    QAction* m_remove_action;
    int m_thickness_row;
    int m_roughness_row;
    SampleEditorController* m_ec;
    QVector<QWidget*> m_structure_editing_widgets;
    WidgetMoverButton* m_move_button;
};

#endif // BORNAGAIN_GUI_VIEW_SAMPLE_LAYERFORM_H
