//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/RoughnessItems.h
//! @brief     Defines classes RoughnessItems.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_ROUGHNESSITEMS_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_ROUGHNESSITEMS_H

#include "GUI/Model/Descriptor/DoubleProperty.h"

class RoughnessItem {
public:
    virtual ~RoughnessItem() = default;

    virtual void writeTo(QXmlStreamWriter* w) const = 0;
    virtual void readFrom(QXmlStreamReader* r) = 0;
    virtual DoubleProperties roughnessProperties() = 0;

protected:
    RoughnessItem() = default;
};

class BasicRoughnessItem : public RoughnessItem {
public:
    BasicRoughnessItem(double sigma, double hurst, double corr_length);

    DoubleProperty& sigma() { return m_sigma; }
    const DoubleProperty& sigma() const { return m_sigma; }
    void setSigma(double v) { m_sigma.setDVal(v); }

    DoubleProperty& hurst() { return m_hurst; }
    const DoubleProperty& hurst() const { return m_hurst; }
    void setHurst(double v) { m_hurst.setDVal(v); }

    DoubleProperty& lateralCorrelationLength() { return m_lateral_correlation_length; }
    const DoubleProperty& lateralCorrelationLength() const { return m_lateral_correlation_length; }
    void setLateralCorrelationLength(double v) { m_lateral_correlation_length.setDVal(v); }

    void writeTo(QXmlStreamWriter* w) const override;
    void readFrom(QXmlStreamReader* r) override;

    DoubleProperties roughnessProperties() override
    {
        return {&m_sigma, &m_hurst, &m_lateral_correlation_length};
    }

private:
    DoubleProperty m_sigma;
    DoubleProperty m_hurst;
    DoubleProperty m_lateral_correlation_length;
};

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_ROUGHNESSITEMS_H
