#!/bin/sh

# Create a second initrd for Debian GNU/Linux. This disk contains the
# OCO (object code only) modules from IBM developerWorks.
#
# Written by Stefan Gybas <sgybas@debian.org>. Released under the GPL!
#
# Instructions: Put all downloaded OCO archives in the current directoy
# and call this script. It will create an compressed initrd image which
# can will be loaded by the Linux kernel after the main initrd.
# Parameters: $1: kernel version (e.g. 2.4.17)

# the kernel version and architecture (s390, x390x)
kver=$1
arch=s390				# or use `uname -m`

# the name of the initrd image, its size and the number of inodes in it
initrd=initrd2.debian-$kver
initsize=225
initinodes=20


# DON'T CHANGE ANYTHING BELOW THIS LINE!


# destination directory inside the initrd
destdir=lib/modules/$kver/kernel/drivers/$arch/net

# create the initrd ext2fs and mount it via loopback
echo "creating initrd image..."
dd if=/dev/zero of=$initrd.tmp bs=1k count=$initsize
mke2fs -O none -F -q -N $initinodes -m 0 $initrd.tmp
grep -q loop /proc/devices || insmod loop
mkdir $initrd.mnt || true
mount -t ext2 -o loop $initrd.tmp $initrd.mnt

# create the directory layout of the initrd
rmdir $initrd.mnt/lost+found
mkdir -p $initrd.mnt/$destdir || true

# unpack the OCO archives
mkdir ${initrd}.${arch} || true
for i in qdio qeth; do
    prefix=${i}-${kver}-${arch}
    if [ -f $prefix*.tar.gz ]; then
        echo -n "Processing $i module for $arch... "
	tmpdir=$initrd.$arch/$i
        mkdir $tmpdir || true
        tar -C $tmpdir -x -z -f $prefix*.tar.gz
        mv $tmpdir/$prefix*.o $initrd.mnt/$destdir/$i.o
        rm -rf $tmpdir
        echo "done."
    else
        echo "$i archive for $kvers ($arch) not found!"
        exit 1
    fi
done
rm -rf $initrd.$arch

# fix permissions, unmount the initrd and compress the image
chown -R root:root $initrd.mnt
umount $initrd.mnt
rm -rf $initrd.mnt
gzip $initrd.tmp
mv $initrd.tmp.gz $initrd
