//We would like to download also only once :: when the first startup.

var gBookmarksSynchronizerService=
{
  xbel:null,

  onload:function()
  {
    gBookmarksSynchronizerService._onload();
  },

  onunload:function()
  {
    gBookmarksSynchronizerService._onunload();
  },

  _onload:function()
  {
    this.xbel=new BookmarksSynchronizerXBEL();
		this.count=this.count+1;
    this._addMenu();
    if( this.xbel.settings.getBool("autodownload", false) && this.count==1)
      setTimeout(gBookmarksSynchronizerService.download,500);
  },

  _onunload:function()
  {
    if(this.xbel.settings.getBool("autoupload", false) && this.count==1)
      this.upload();
		this.count=this.count-1;
  },

	get count()
	{
		return nsPreferences.getIntPref("bookmarksftp.browsercount",0);
	},

	set count(aVal)
	{
		if(aVal<0)
			aVal=0;
		nsPreferences.setIntPref("bookmarksftp.browsercount", aVal);
	},

  upload:function()
  {
    window.open("chrome://bookmarksftp/content/upload.xul","_blank","chrome,resizable,titlebar=no");
  },

  download:function()
  {
    gBookmarksSynchronizerService.xbel.updateUndoCache();
    window.open("chrome://bookmarksftp/content/download.xul","_blank","chrome,resizable,titlebar=no");
  },

  settings:function()
  {
    window.open("chrome://bookmarksftp/content/bmsyncOptions.xul","_bmsync_settings_","chrome");
  },

  _addMenu:function()
  {
    try{
      var menu=document.getElementById("bookmarks-menu");
      var popup=menu.firstChild;
      var sep=popup.getElementsByTagName("menuseparator")[0];
      var label=this.xbel.settings.getString("settingslabel");
      var accesskey=this.xbel.settings.getString("settingsaccesskey");
    }catch(e){alert(e); return;}
  
    var  element = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "menuitem");
    element.setAttribute("id", "bookmarks-menuitem-sort");
    element.setAttribute("label", label);
    element.setAttribute("accesskey", accesskey);
    element.setAttribute("oncommand", "gBookmarksSynchronizerService.settings();");
    popup.insertBefore(element,sep);
  },

  unregObserver:function()
  {
    try{
      var bt = document.getElementById("bookmarks-ptf");
      if (bt && bt.hasAttribute("ref") && bt.ref)
        bt.database.RemoveObserver(BookmarksToolbarRDFObserver);
    }catch(e){alert(e);}
  },

  regObserver:function()
  {
    try{
      var bt = document.getElementById("bookmarks-ptf");
      if (bt) 
      {
        var btf="rdf:null";
        try{
          btf= BMSVC.getBookmarksToolbarFolder().Value;
        }catch(e){}
        bt.ref=btf;
        document.getElementById("bookmarks-chevron").ref = btf;
        bt.database.AddObserver(BookmarksToolbarRDFObserver);
      }
    }catch(e){ alert(e);}
  }
};

//Event Listeners
window.addEventListener("load", gBookmarksSynchronizerService.onload, false);
window.addEventListener("unload", gBookmarksSynchronizerService.onunload, false);
