﻿#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by
// astgenerator.boo on 29/6/2005 15:54:04
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class ForStatementImpl : Statement
	{

		protected DeclarationCollection _declarations;
		protected Expression _iterator;
		protected Block _block;

		protected ForStatementImpl()
		{
			InitializeFields();
		}
		
		protected ForStatementImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		

		protected ForStatementImpl(Expression iterator)
		{
			InitializeFields();
			Iterator = iterator;
		}
			
		protected ForStatementImpl(LexicalInfo lexicalInfo, Expression iterator) : base(lexicalInfo)
		{
			InitializeFields();
			Iterator = iterator;
		}
			
		new public ForStatement CloneNode()
		{
			return Clone() as ForStatement;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.ForStatement;
			}
		}

		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}

			if (_modifier == existing)
			{
				this.Modifier = (StatementModifier)newNode;
				return true;
			}

			if (_declarations != null)
			{
				Declaration item = existing as Declaration;
				if (null != item)
				{
					Declaration newItem = (Declaration)newNode;
					if (_declarations.Replace(item, newItem))
					{
						return true;
					}
				}
			}

			if (_iterator == existing)
			{
				this.Iterator = (Expression)newNode;
				return true;
			}

			if (_block == existing)
			{
				this.Block = (Block)newNode;
				return true;
			}

			return false;
		}

		override public object Clone()
		{
			ForStatement clone = FormatterServices.GetUninitializedObject(typeof(ForStatement)) as ForStatement;
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			clone._entity = _entity;
			clone._annotations = null != _annotations ? (Hashtable)_annotations.Clone() : null;
			

			if (null != _modifier)
			{
				clone._modifier = _modifier.Clone() as StatementModifier;
				clone._modifier.InitializeParent(clone);
			}

			if (null != _declarations)
			{
				clone._declarations = _declarations.Clone() as DeclarationCollection;
				clone._declarations.InitializeParent(clone);
			}

			if (null != _iterator)
			{
				clone._iterator = _iterator.Clone() as Expression;
				clone._iterator.InitializeParent(clone);
			}

			if (null != _block)
			{
				clone._block = _block.Clone() as Block;
				clone._block.InitializeParent(clone);
			}
			
			return clone;
		}
			
		override public void ClearTypeSystemBindings()
		{
			_annotations = null;
			_entity = null;
			

			if (null != _modifier)
			{
				_modifier.ClearTypeSystemBindings();
			}

			if (null != _declarations)
			{
				_declarations.ClearTypeSystemBindings();
			}

			if (null != _iterator)
			{
				_iterator.ClearTypeSystemBindings();
			}

			if (null != _block)
			{
				_block.ClearTypeSystemBindings();
			}

		}

		[System.Xml.Serialization.XmlElement]
		public DeclarationCollection Declarations
		{
			get
			{
				return _declarations;
			}
			

			set
			{
				if (_declarations != value)
				{
					_declarations = value;
					if (null != _declarations)
					{
						_declarations.InitializeParent(this);

					}
				}
			}
			

		}
		

		[System.Xml.Serialization.XmlElement]
		public Expression Iterator
		{
			get
			{
				return _iterator;
			}
			

			set
			{
				if (_iterator != value)
				{
					_iterator = value;
					if (null != _iterator)
					{
						_iterator.InitializeParent(this);

					}
				}
			}
			

		}
		

		[System.Xml.Serialization.XmlElement]
		public Block Block
		{
			get
			{
				return _block;
			}
			

			set
			{
				if (_block != value)
				{
					_block = value;
					if (null != _block)
					{
						_block.InitializeParent(this);

					}
				}
			}
			

		}
		

		private void InitializeFields()
		{
			_declarations = new DeclarationCollection(this);

			_block = new Block();
			_block.InitializeParent(this);
			

		}
	}
}
