/***************************************************************************
 *            song-properties.h
 *
 *  lun avr 10 18:39:17 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SONG_PROPERTIES_H
#define SONG_PROPERTIES_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkdialog.h>

#include "burn-basics.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_SONG_PROPS         (bonfire_song_props_get_type ())
#define BONFIRE_SONG_PROPS(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_SONG_PROPS, BonfireSongProps))
#define BONFIRE_SONG_PROPS_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_SONG_PROPS, BonfireSongPropsClass))
#define BONFIRE_IS_SONG_PROPS(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_SONG_PROPS))
#define BONFIRE_IS_SONG_PROPS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_SONG_PROPS))
#define BONFIRE_SONG_PROPS_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_SONG_PROPS, BonfireSongPropsClass))

typedef struct BonfireSongPropsPrivate BonfireSongPropsPrivate;

typedef struct {
	GtkDialog parent;
	BonfireSongPropsPrivate *priv;
} BonfireSongProps;

typedef struct {
	GtkDialogClass parent_class;
} BonfireSongPropsClass;

GType bonfire_song_props_get_type ();
GtkWidget *bonfire_song_props_new ();

void
bonfire_song_props_get_properties (BonfireSongProps *self,
				   char **artist,
				   char **title,
				   char **composer,
				   int *isrc);
void
bonfire_song_props_set_properties (BonfireSongProps *self,
				   int track_num,
				   const char *artist,
				   const char *title,
				   const char *composer,
				   int isrc);
#endif /* SONG_PROPERTIES_H */
