/***************************************************************************
*            search-entry.h
*
*  jeu mai 19 20:06:55 2005
*  Copyright  2005  Philippe Rouquier
*  bonfire-app@wanadoo.fr
****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef BUILD_SEARCH

#ifndef SEARCH_ENTRY_H
#define SEARCH_ENTRY_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkhbox.h>

#include <beagle/beagle-query.h>

G_BEGIN_DECLS
#define BONFIRE_TYPE_SEARCH_ENTRY         (bonfire_search_entry_get_type ())
#define BONFIRE_SEARCH_ENTRY(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_SEARCH_ENTRY, BonfireSearchEntry))
#define BONFIRE_SEARCH_ENTRY_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_SEARCH_ENTRY, BonfireSearchEntryClass))
#define BONFIRE_IS_SEARCH_ENTRY(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_SEARCH_ENTRY))
#define BONFIRE_IS_SEARCH_ENTRY_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_SEARCH_ENTRY))
#define BONFIRE_SEARCH_ENTRY_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_SEARCH_ENTRY, BonfireSearchEntryClass))
typedef struct BonfireSearchEntryPrivate BonfireSearchEntryPrivate;

typedef struct {
	GtkHBox parent;
	BonfireSearchEntryPrivate *priv;
} BonfireSearchEntry;

typedef struct {
	GtkHBoxClass parent_class;

	void	(*activated)	(BonfireSearchEntry *entry);

} BonfireSearchEntryClass;

GType bonfire_search_entry_get_type ();
GtkWidget *bonfire_search_entry_new ();

BeagleQuery *
bonfire_search_entry_get_query (BonfireSearchEntry *entry);

#endif				/* SEARCH_ENTRY_H */

#endif
