/***************************************************************************
*            cd-type-chooser.h
*
*  ven mai 27 17:33:12 2005
*  Copyright  2005  Philippe Rouquier
*  bonfire-app@wanadoo.fr
****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CD_TYPE_CHOOSER_H
#define CD_TYPE_CHOOSER_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkeventbox.h>

G_BEGIN_DECLS
#define BONFIRE_TYPE_PROJECT_TYPE_CHOOSER         (bonfire_project_type_chooser_get_type ())
#define BONFIRE_PROJECT_TYPE_CHOOSER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_PROJECT_TYPE_CHOOSER, BonfireProjectTypeChooser))
#define BONFIRE_PROJECT_TYPE_CHOOSER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k),BONFIRE_TYPE_PROJECT_TYPE_CHOOSER, BonfireProjectTypeChooserClass))
#define BONFIRE_IS_PROJECT_TYPE_CHOOSER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_PROJECT_TYPE_CHOOSER))
#define BONFIRE_IS_PROJECT_TYPE_CHOOSER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_PROJECT_TYPE_CHOOSER))
#define BONFIRE_PROJECT_TYPE_CHOOSER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_PROJECT_TYPE_CHOOSER, BonfireProjectTypeChooserClass))

typedef struct BonfireProjectTypeChooserPrivate BonfireProjectTypeChooserPrivate;

typedef struct {
	GtkEventBox parent;
	BonfireProjectTypeChooserPrivate *priv;
} BonfireProjectTypeChooser;

typedef enum {
	BONFIRE_PROJECT_TYPE_INVALID,
	BONFIRE_PROJECT_TYPE_COPY,
	BONFIRE_PROJECT_TYPE_ISO,
	BONFIRE_PROJECT_TYPE_AUDIO,
	BONFIRE_PROJECT_TYPE_DATA,
} BonfireProjectType;

typedef struct {
	GtkEventBoxClass parent_class;

	void (*chosen) (BonfireProjectTypeChooser *chooser,
			BonfireProjectType type);
} BonfireProjectTypeChooserClass;

GType bonfire_project_type_chooser_get_type ();
GtkWidget *bonfire_project_type_chooser_new ();

#endif				/* CD_TYPE_CHOOSER_H */
