/***************************************************************************
 *            progress.h
 *
 *  ven mar 10 15:42:01 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PROGRESS_H
#define PROGRESS_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkwidget.h>
#include <gtk/gtkvbox.h>

#include "burn-basics.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_BURN_PROGRESS         (bonfire_burn_progress_get_type ())
#define BONFIRE_BURN_PROGRESS(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_BURN_PROGRESS, BonfireBurnProgress))
#define BONFIRE_BURN_PROGRESS_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_BURN_PROGRESS, BonfireBurnProgressClass))
#define BONFIRE_IS_BURN_PROGRESS(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_BURN_PROGRESS))
#define BONFIRE_IS_BURN_PROGRESS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_BURN_PROGRESS))
#define BONFIRE_BURN_PROGRESS_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_BURN_PROGRESS, BonfireBurnProgressClass))

typedef struct BonfireBurnProgressPrivate BonfireBurnProgressPrivate;

typedef struct {
	GtkVBox parent;
	BonfireBurnProgressPrivate *priv;
} BonfireBurnProgress;

typedef struct {
	GtkVBoxClass parent_class;
} BonfireBurnProgressClass;

GType bonfire_burn_progress_get_type();

GtkWidget *bonfire_burn_progress_new();

void
bonfire_burn_progress_set_status (BonfireBurnProgress *progress,
				  double fraction,
				  long remaining,
				  int mb_isosize,
				  int mb_written,
				  int speed,
				  int fifo);

void
bonfire_burn_progress_set_action (BonfireBurnProgress *progress,
				  BonfireBurnAction action,
				  const char *string);

void
bonfire_burn_progress_set_spinning (BonfireBurnProgress *progress,
				    gboolean spinning);

#endif /* PROGRESS_H */
