/***************************************************************************
*            player.h
*
*  lun mai 30 08:15:01 2005
*  Copyright  2005  Philippe Rouquier
*  bonfire-app@wanadoo.fr
****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef BUILD_PREVIEW

#ifndef PLAYER_H
#define PLAYER_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkalignment.h>

#include "bonfire-uri-container.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_PLAYER         (bonfire_player_get_type ())
#define BONFIRE_PLAYER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_PLAYER, BonfirePlayer))
#define BONFIRE_PLAYER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_PLAYER, BonfirePlayerClass))
#define BONFIRE_IS_PLAYER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_PLAYER))
#define BONFIRE_IS_PLAYER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_PLAYER))
#define BONFIRE_PLAYER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_PLAYER, BonfirePlayerClass))
typedef struct BonfirePlayerPrivate BonfirePlayerPrivate;

typedef struct {
	GtkAlignment parent;
	BonfirePlayerPrivate *priv;
} BonfirePlayer;

typedef struct {
	GtkAlignmentClass parent_class;
} BonfirePlayerClass;

GType bonfire_player_get_type ();
GtkWidget *bonfire_player_new ();

void
bonfire_player_set_uri (BonfirePlayer *player, const char *uri);
void
bonfire_player_add_source (BonfirePlayer *player, BonfireURIContainer *source);

#endif				/* PLAYER_H */

#endif
