/***************************************************************************
 *            metadata.h
 *
 *  jeu jui 28 12:49:41 2005
 *  Copyright  2005  Philippe Rouquier
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef METADATA_H
#define METADATA_H

#include <glib.h>
#include <glib-object.h>

#include <gst/gst.h>

G_BEGIN_DECLS
#define BONFIRE_TYPE_METADATA         (bonfire_metadata_get_type ())
#define BONFIRE_METADATA(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_METADATA, BonfireMetadata))
#define BONFIRE_METADATA_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_METADATA, BonfireMetadataClass))
#define BONFIRE_IS_METADATA(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_METADATA))
#define BONFIRE_IS_METADATA_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_METADATA))
#define BONFIRE_METADATA_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_METADATA, BonfireMetadataClass))

typedef struct BonfireMetadataPrivate BonfireMetadataPrivate;

typedef struct {
	GObject parent;

	gchar *uri;
	gchar *type;
	gchar *title;
	gchar *artist;
	gchar *album;
	gchar *composer;
	gchar *musicbrainz_id;
	int isrc;
	gint64 len;

	gboolean is_seekable;

	BonfireMetadataPrivate *priv;
} BonfireMetadata;

typedef struct {
	GObjectClass parent_class;

	void (*completed) (BonfireMetadata *meta, const GError *error);

} BonfireMetadataClass;

GType bonfire_metadata_get_type ();
BonfireMetadata *bonfire_metadata_new (const char *uri);

void bonfire_metadata_cancel (BonfireMetadata *metadata);

gboolean bonfire_metadata_get (BonfireMetadata * meta,
			       GError ** error);
gboolean bonfire_metadata_get_sync (BonfireMetadata * metadata,
				    GError ** error);
gboolean bonfire_metadata_get_async (BonfireMetadata * metadata);

const char *bonfire_metadata_get_title (BonfireMetadata * metadata);
const char *bonfire_metadata_get_length (BonfireMetadata * metadata);
const char *bonfire_metadata_get_artist (BonfireMetadata * metadata);


#endif				/* METADATA_H */
