/***************************************************************************
 *            filtered-window.h
 *
 *  dim oct 30 12:25:50 2005
 *  Copyright  2005  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef FILTERED_WINDOW_H
#define FILTERED_WINDOW_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkdialog.h>

G_BEGIN_DECLS

#define BONFIRE_TYPE_FILTERED_DIALOG         (bonfire_filtered_dialog_get_type ())
#define BONFIRE_FILTERED_DIALOG(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_FILTERED_DIALOG, BonfireFilteredDialog))
#define BONFIRE_FILTERED_DIALOG_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_FILTERED_DIALOG, BonfireFilteredDialogClass))
#define BONFIRE_IS_FILTERED_DIALOG(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_FILTERED_DIALOG))
#define BONFIRE_IS_FILTERED_DIALOG_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_FILTERED_DIALOG))
#define BONFIRE_FILTERED_DIALOG_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_FILTERED_DIALOG, BonfireFilteredDialogClass))

typedef struct BonfireFilteredDialogPrivate BonfireFilteredDialogPrivate;

typedef enum {
	BONFIRE_FILTER_HIDDEN = 1,
	BONFIRE_FILTER_UNREADABLE,
	BONFIRE_FILTER_BROKEN_SYM,
	BONFIRE_FILTER_RECURSIVE_SYM,
	BONFIRE_FILTER_JOLIET_INCOMPAT,
	BONFIRE_FILTER_UNKNOWN
} BonfireFilterStatus;

typedef struct {
	GtkDialog parent;
	BonfireFilteredDialogPrivate *priv;
} BonfireFilteredDialog;

typedef struct {
	GtkDialogClass parent_class;

	void (*removed) (BonfireFilteredDialog *window, const char *uri);
	void (*restored) (BonfireFilteredDialog *window, const char *uri);
} BonfireFilteredDialogClass;

GType bonfire_filtered_dialog_get_type();
GtkWidget *bonfire_filtered_dialog_new();

void
bonfire_filtered_dialog_add (BonfireFilteredDialog *window,
			     const char *uri,
			     gboolean restored,
			     BonfireFilterStatus status);

void
bonfire_filtered_dialog_get_status (BonfireFilteredDialog *dialog,
				    GSList **restored,
				    GSList **removed);

#endif /* FILTERED_WINDOW_H */
