/***************************************************************************
 *            burn.h
 *
 *  ven mar  3 18:50:18 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BURN_H
#define BURN_H

#include <glib.h>
#include <glib-object.h>

#include <nautilus-burn-drive.h>

#include "burn-basics.h"
#include "burn-caps.h"
#include "progress.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_BURN         (bonfire_burn_get_type ())
#define BONFIRE_BURN(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_BURN, BonfireBurn))
#define BONFIRE_BURN_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_BURN, BonfireBurnClass))
#define BONFIRE_IS_BURN(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_BURN))
#define BONFIRE_IS_BURN_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_BURN))
#define BONFIRE_BURN_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_BURN, BonfireBurnClass))

typedef struct BonfireBurnPrivate BonfireBurnPrivate;

typedef struct {
	GObject parent;
	BonfireBurnPrivate *priv;
} BonfireBurn;

typedef struct {
	GObjectClass parent_class;

	/* signals */
	BonfireBurnResult		(*insert_media_request)		(BonfireBurn *obj,
									 BonfireMediaType error,
									 BonfireMediaType required_media);

	BonfireBurnResult		(*ask_disable_joliet)		(BonfireBurn *obj);

	BonfireBurnResult		(*warn_data_loss)		(BonfireBurn *obj);
	BonfireBurnResult		(*warn_rewritable)		(BonfireBurn *obj);

	BonfireBurnResult		(*progress_changed)		(BonfireBurn *obj,
									 double progress,
									 long time_remaining);
	BonfireBurnResult		(*action_changed)		(BonfireBurn *obj,
									 BonfireBurnAction action);
} BonfireBurnClass;

GType bonfire_burn_get_type ();
BonfireBurn *bonfire_burn_new ();

BonfireBurnResult 
bonfire_burn_image (BonfireBurn *burn,
		    BonfireBurnFlag flags,
		    const BonfireTrackSource *source,
		    BonfireTrackSourceType target,
		    NautilusBurnDrive *drive, 	/* used when multisession */
		    const char *output,
		    GError **error);

BonfireBurnResult 
bonfire_burn_record (BonfireBurn *burn,
		     BonfireBurnFlag flags,
		     NautilusBurnDrive *drive,
		     gint speed,
		     const BonfireTrackSource *source,
		     const char *output,
		     GError **error);

BonfireBurnResult
bonfire_burn_blank (BonfireBurn *burn,
		    BonfireBurnFlag flags,
		    NautilusBurnDrive *drive,
		    gboolean fast,
		    GError **error);

BonfireBurnResult
bonfire_burn_cancel (BonfireBurn *burn, gboolean protect);

BonfireBurnResult
bonfire_burn_status (BonfireBurn *burn,
		     gint64 *isosize,
		     gint64 *written,
		     gint *speed,
		     gint *fifo);

void
bonfire_burn_plug_progress_widget (BonfireBurn *burn,
				   BonfireBurnProgress *progress);

#endif /* BURN_H */
