/***************************************************************************
 *            transcode.h
 *
 *  ven jui  8 16:15:04 2005
 *  Copyright  2005  Philippe Rouquier
 *  Bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TRANSCODE_H
#define TRANSCODE_H

#include <glib.h>
#include <glib-object.h>

#include "burn-job.h"

G_BEGIN_DECLS
#define BONFIRE_TYPE_TRANSCODE         (bonfire_transcode_get_type ())
#define BONFIRE_TRANSCODE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_TRANSCODE, BonfireTranscode))
#define BONFIRE_TRANSCODE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_TRANSCODE, BonfireTranscodeClass))
#define BONFIRE_IS_TRANSCODE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_TRANSCODE))
#define BONFIRE_IS_TRANSCODE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_TRANSCODE))
#define BONFIRE_TRANSCODE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_TRANSCODE, BonfireTranscodeClass))

typedef struct BonfireTranscodePrivate BonfireTranscodePrivate;

typedef struct {
	BonfireJob parent;
	BonfireTranscodePrivate *priv;
} BonfireTranscode;

typedef struct {
	BonfireJobClass parent_class;
} BonfireTranscodeClass;

GType bonfire_transcode_get_type ();

BonfireTranscode *bonfire_transcode_new ();

#endif				/* TRANSCODE_H */
