/***************************************************************************
 *            recorder.h
 *
 *  dim jan 22 17:31:49 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef RECORDER_H
#define RECORDER_H

#include <glib.h>
#include <glib-object.h>

#include <nautilus-burn-drive.h>

#include "burn-basics.h"

G_BEGIN_DECLS

typedef enum {
	BONFIRE_RECORDER_FLAG_NONE		= 0,
	BONFIRE_RECORDER_FLAG_NOGRACE		= 1,
	BONFIRE_RECORDER_FLAG_DAO		= 1 << 1,
	BONFIRE_RECORDER_FLAG_MULTI		= 1 << 2,
	BONFIRE_RECORDER_FLAG_DUMMY		= 1 << 3,
	BONFIRE_RECORDER_FLAG_OVERBURN		= 1 << 4,
	BONFIRE_RECORDER_FLAG_BURNPROOF		= 1 << 5,
	BONFIRE_RECORDER_FLAG_FAST_BLANK	= 1 << 6
} BonfireRecorderFlag;

#define BONFIRE_TYPE_RECORDER         (bonfire_recorder_get_type ())
#define BONFIRE_RECORDER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_RECORDER, BonfireRecorder))
#define BONFIRE_IS_RECORDER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_RECORDER))
#define BONFIRE_RECORDER_GET_IFACE(o) (G_TYPE_INSTANCE_GET_INTERFACE ((o), BONFIRE_TYPE_RECORDER, BonfireRecorderIFace))

typedef struct _BonfireRecorder BonfireRecorder;
typedef struct _BonfireRecorderIFace BonfireRecorderIFace;

struct _BonfireRecorderIFace{
	GTypeInterface parent_class;

	/* methods */
	BonfireBurnResult	(*set_drive)		(BonfireRecorder *recorder,
							 NautilusBurnDrive *drive,
							 GError **error);
	BonfireBurnResult	(*set_flags)		(BonfireRecorder *recorder,
							 BonfireRecorderFlag flags,
							 GError **error);

	BonfireBurnResult	(*record)		(BonfireRecorder *recorder,
							 GError **error);
	BonfireBurnResult	(*blank)		(BonfireRecorder *recorder,
							 GError **error);

	BonfireBurnResult	(*get_status)		(BonfireRecorder *recorder,
							 int *speed,
							 int *fifo,
							 gint64 *bytes_written);
};

GType bonfire_recorder_get_type();

BonfireBurnResult
bonfire_recorder_set_flags (BonfireRecorder *recorder,
			    BonfireRecorderFlag flags,
			    GError **error);
BonfireBurnResult
bonfire_recorder_set_drive (BonfireRecorder *recorder,
			    NautilusBurnDrive *drive,
			    GError **error);

BonfireBurnResult
bonfire_recorder_blank (BonfireRecorder *recorder,
			GError **error);

BonfireBurnResult
bonfire_recorder_record (BonfireRecorder *recorder,
			 GError **error);

BonfireBurnResult
bonfire_recorder_get_status (BonfireRecorder *recorder,
			     int *speed,
			     int *fifo,
			     gint64 *bytes_written);

#endif /* RECORDER_H */
