/***************************************************************************
 *            imager.h
 *
 *  dim jan 22 17:32:17 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef IMAGER_H
#define IMAGER_H

#include <glib.h>
#include <glib-object.h>

#include <nautilus-burn-drive.h>

#include "burn-basics.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_IMAGER         (bonfire_imager_get_type ())
#define BONFIRE_IMAGER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_IMAGER, BonfireImager))
#define BONFIRE_IS_IMAGER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_IMAGER))
#define BONFIRE_IMAGER_GET_IFACE(o) (G_TYPE_INSTANCE_GET_INTERFACE ((o), BONFIRE_TYPE_IMAGER, BonfireImagerIFace))

typedef struct _BonfireImagerIFace BonfireImagerIFace;

struct _BonfireImagerIFace {
	GTypeInterface parent_class;

	/* virtual functions */
	BonfireBurnResult	(*get_track_type)	(BonfireImager *imager,
							 BonfireTrackSourceType *type);
	BonfireBurnResult	(*get_speed)		(BonfireImager *imager,
							 int *speed);

	BonfireBurnResult	(*get_track)		(BonfireImager *imager,
							 BonfireTrackSource **track,
							 GError **error);
	BonfireBurnResult	(*get_size)		(BonfireImager *imager,
							 gint64 *size,
							 gboolean sectors,
							 GError **error);

	BonfireBurnResult	(*set_append)          	(BonfireImager *imager,
							 NautilusBurnDrive *drive,
							 gboolean merge,
							 GError **error);

	BonfireBurnResult	(*set_output_type)	(BonfireImager *imager,
							 BonfireTrackSourceType type,
							 GError **error);

	BonfireBurnResult	(*set_output)          	(BonfireImager *imager,
							 const char *output,
							 gboolean overwrite,
							 gboolean clean,
							 GError **error);
};

GType bonfire_imager_get_type();

BonfireBurnResult
bonfire_imager_set_output (BonfireImager *imager,
			   const char *output,
			   gboolean overwrite,
			   gboolean clean,
			   GError **error);
BonfireBurnResult
bonfire_imager_set_output_type (BonfireImager *imager,
				BonfireTrackSourceType type,
				GError **error);
BonfireBurnResult
bonfire_imager_set_append (BonfireImager *imager,
			   NautilusBurnDrive *drive,
			   gboolean merge,
			   GError **error);

BonfireBurnResult
bonfire_imager_get_track (BonfireImager *imager,
			  BonfireTrackSource **track,
			  GError **error);
BonfireBurnResult
bonfire_imager_get_size (BonfireImager *imager,
			 gint64 *size,
			 gboolean sectors,
			 GError **error);

BonfireBurnResult
bonfire_imager_get_track_type (BonfireImager *imager, BonfireTrackSourceType *type);
BonfireBurnResult
bonfire_imager_get_speed (BonfireImager *imager, int *speed);

#endif /* IMAGER_H */
