/***************************************************************************
 *            burn-dialog.h
 *
 *  mer jun 29 13:05:45 2005
 *  Copyright  2005  Philippe Rouquier
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BURN_DIALOG_H
#define BURN_DIALOG_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkwidget.h>
#include <gtk/gtkdialog.h>

#include "burn-basics.h"
#include "burn.h"

G_BEGIN_DECLS
#define BONFIRE_TYPE_BURN_DIALOG         (bonfire_burn_dialog_get_type ())
#define BONFIRE_BURN_DIALOG(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_BURN_DIALOG, BonfireBurnDialog))
#define BONFIRE_BURN_DIALOG_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_BURN_DIALOG, BonfireBurnDialogClass))
#define BONFIRE_IS_BURN_DIALOG(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_BURN_DIALOG))
#define BONFIRE_IS_BURN_DIALOG_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_BURN_DIALOG))
#define BONFIRE_BURN_DIALOG_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_BURN_DIALOG, BonfireBurnDialogClass))
typedef struct BonfireBurnDialogPrivate BonfireBurnDialogPrivate;

typedef struct {
	GtkDialog parent;
	BonfireBurnDialogPrivate *priv;
} BonfireBurnDialog;

typedef struct {
	GtkDialogClass parent_class;
} BonfireBurnDialogClass;

GType bonfire_burn_dialog_get_type ();
GtkWidget *bonfire_burn_dialog_new (void);

void
bonfire_burn_dialog_run (BonfireBurnDialog *dialog,
			 NautilusBurnDrive *drive,
			 gint speed,
			 const char *output,
			 const BonfireTrackSource *track,
			 BonfireBurnFlag flags);

#endif				/* BURN_DIALOG_H */
