/***************************************************************************
 *            burn-caps.h
 *
 *  mar avr 18 20:58:42 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BURN_CAPS_H
#define BURN_CAPS_H

#include <glib.h>
#include <glib-object.h>

#include <nautilus-burn-drive.h>

#include "burn-basics.h"
#include "burn-recorder.h"
#include "burn-imager.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_BURNCAPS         (bonfire_burn_caps_get_type ())
#define BONFIRE_BURNCAPS(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_BURNCAPS, BonfireBurnCaps))
#define BONFIRE_BURNCAPS_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_BURNCAPS, BonfireBurnCapsClass))
#define BONFIRE_IS_BURNCAPS(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_BURNCAPS))
#define BONFIRE_IS_BURNCAPS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_BURNCAPS))
#define BONFIRE_BURNCAPS_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_BURNCAPS, BonfireBurnCapsClass))

typedef enum {
	BONFIRE_BURN_FLAG_NONE			= 0,
	BONFIRE_BURN_FLAG_EJECT			= 1,
	BONFIRE_BURN_FLAG_NOGRACE		= 1 << 1,

	BONFIRE_BURN_FLAG_DAO			= 1 << 2,
	BONFIRE_BURN_FLAG_OVERBURN		= 1 << 3,
	BONFIRE_BURN_FLAG_BURNPROOF		= 1 << 4,
	BONFIRE_BURN_FLAG_ON_THE_FLY		= 1 << 5,

	BONFIRE_BURN_FLAG_BLANK_BEFORE_WRITE	= 1 << 6,
	BONFIRE_BURN_FLAG_DONT_CLEAN_OUTPUT	= 1 << 7,
	BONFIRE_BURN_FLAG_DONT_OVERWRITE	= 1 << 8,

	BONFIRE_BURN_FLAG_DONT_CLOSE		= 1 << 9,
	BONFIRE_BURN_FLAG_APPEND		= 1 << 10,
	BONFIRE_BURN_FLAG_MERGE			= 1 << 11,

	BONFIRE_BURN_FLAG_DUMMY			= 1 << 12,
	BONFIRE_BURN_FLAG_DEBUG			= 1 << 13,

	BONFIRE_BURN_FLAG_CHECK_SIZE		= 1 << 14
} BonfireBurnFlag;

typedef struct BonfireBurnCapsPrivate BonfireBurnCapsPrivate;

typedef struct {
	GObject parent;
	BonfireBurnCapsPrivate *priv;
} BonfireBurnCaps;

typedef struct {
	GObjectClass parent_class;
} BonfireBurnCapsClass;

GType bonfire_burn_caps_get_type();

BonfireBurnCaps *bonfire_burn_caps_get_default ();

BonfireBurnResult
bonfire_burn_caps_get_default_flags (BonfireBurnCaps *caps,
				     BonfireTrackSourceType track_type,
				     NautilusBurnDriveType drive_type,
				     NautilusBurnMediaType media_type,
				     BonfireBurnFlag *flags);

BonfireBurnResult
bonfire_burn_caps_get_supported_flags (BonfireBurnCaps *caps,
				       BonfireTrackSourceType track_type,
				       NautilusBurnDriveType drive_type,
				       NautilusBurnMediaType media_type,
				       BonfireBurnFlag *flags);

BonfireBurnFlag
bonfire_burn_caps_check_flags_consistency (BonfireBurnCaps *caps,
					   BonfireTrackSourceType track_type,
					   NautilusBurnDriveType drive_type,
					   NautilusBurnMediaType media_type,
					   BonfireBurnFlag flags);

BonfireBurnResult
bonfire_burn_caps_create_imager (BonfireBurnCaps *caps,
				 BonfireImager **imager,
				 const BonfireTrackSource *source,
				 BonfireTrackSourceType target,
				 NautilusBurnMediaType src_media_type,
				 NautilusBurnMediaType dest_media_type,
				 GError **error);

BonfireBurnResult
bonfire_burn_caps_get_imager_available_targets (BonfireBurnCaps *caps,
						BonfireTrackSourceType **targets,
						BonfireTrackSourceType source_type,
						NautilusBurnMediaType src_media_type);
BonfireTrackSourceType
bonfire_burn_caps_get_imager_default_target (BonfireBurnCaps *caps,
					     BonfireTrackSourceType source_type,
					     NautilusBurnMediaType src_media_type);

BonfireBurnResult
bonfire_burn_caps_create_recorder (BonfireBurnCaps *caps,
				   BonfireRecorder **recorder,
				   BonfireTrackSource *source,
				   NautilusBurnMediaType media_type,
				   GError **error);

BonfireBurnResult
bonfire_burn_caps_create_recorder_for_blanking (BonfireBurnCaps *caps,
						BonfireRecorder **recorder,
						NautilusBurnMediaType type,
						GError **error);

BonfireMediaType
bonfire_burn_caps_get_required_media_type (BonfireBurnCaps *caps,
					   BonfireTrackSourceType track_type);

#endif /* BURN_CAPS_H */
