/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/***************************************************************************
 *            burn-basics.h
 *
 *  Sat Feb 11 16:49:00 2006
 *  Copyright  2006  philippe
 *  <bonfire-app@wanadoo.fr>
 ****************************************************************************/
#ifndef _BURN_BASICS_H
#define _BURN_BASICS_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <glib.h>

#include <nautilus-burn-drive.h>

#define CDR_SPEED 153600
#define DVD_SPEED 1385000

GQuark bonfire_burn_quark (void);
#define BONFIRE_BURN_ERROR bonfire_burn_quark()

typedef enum {
	BONFIRE_BURN_ERROR_NONE,
	BONFIRE_BURN_ERROR_GENERAL,

	BONFIRE_BURN_ERROR_TMP_DIR,
	BONFIRE_BURN_ERROR_FILE_EXIST,
	BONFIRE_BURN_ERROR_INVALID_FILE,
	BONFIRE_BURN_ERROR_INCOMPATIBLE_FORMAT,
	BONFIRE_BURN_ERROR_JOLIET_TREE,

	BONFIRE_BURN_ERROR_SCSI_IOCTL,
	BONFIRE_BURN_ERROR_SLOW_DMA,
	BONFIRE_BURN_ERROR_PERMISSION,
	BONFIRE_BURN_ERROR_BUSY_DRIVE,

	BONFIRE_BURN_ERROR_DISC_SPACE,

	BONFIRE_BURN_ERROR_MEDIA_SPACE,
	BONFIRE_BURN_ERROR_RELOAD_MEDIA,
	BONFIRE_BURN_ERROR_MEDIA_BLANK,
	BONFIRE_BURN_ERROR_MEDIA_BUSY,
	BONFIRE_BURN_ERROR_MEDIA_NONE,
	BONFIRE_BURN_ERROR_MEDIA_NOT_REWRITABLE,
	BONFIRE_BURN_ERROR_MEDIA_NOT_WRITABLE,
	BONFIRE_BURN_ERROR_DVD_NOT_SUPPORTED,
	BONFIRE_BURN_ERROR_CD_NOT_SUPPORTED,
} BonfireBurnError;

typedef enum {
	BONFIRE_BURN_OK,
	BONFIRE_BURN_ERR,
	BONFIRE_BURN_RETRY,
	BONFIRE_BURN_CANCEL,
	BONFIRE_BURN_RUNNING,
	BONFIRE_BURN_DANGEROUS,
	BONFIRE_BURN_NOT_READY,
	BONFIRE_BURN_NOT_RUNNING,
	BONFIRE_BURN_NEED_RELOAD,
	BONFIRE_BURN_NOT_SUPPORTED,
} BonfireBurnResult;

typedef enum {
	BONFIRE_BURN_ACTION_NONE		= 0,
	BONFIRE_BURN_ACTION_GETTING_SIZE,
	BONFIRE_BURN_ACTION_CREATING_IMAGE,
	BONFIRE_BURN_ACTION_DRIVE_COPY,
	BONFIRE_BURN_ACTION_FILE_COPY,
	BONFIRE_BURN_ACTION_ANALYSING,
	BONFIRE_BURN_ACTION_TRANSCODING,
	BONFIRE_BURN_ACTION_PREPARING,
	BONFIRE_BURN_ACTION_WRITING,
	BONFIRE_BURN_ACTION_WRITING_CD_TEXT,
	BONFIRE_BURN_ACTION_FIXATING,
	BONFIRE_BURN_ACTION_BLANKING,
	BONFIRE_BURN_ACTION_FINISHED,
	BONFIRE_BURN_ACTION_LAST
} BonfireBurnAction;

typedef enum {
	BONFIRE_MEDIA_NONE			= 0,
	BONFIRE_MEDIA_TYPE_DVD			= 1,
	BONFIRE_MEDIA_TYPE_CD			= 1 << 1,
	BONFIRE_MEDIA_BLANK			= 1 << 2,
	BONFIRE_MEDIA_WITH_DATA			= 1 << 3,
	BONFIRE_MEDIA_REWRITABLE		= 1 << 4,
	BONFIRE_MEDIA_WRITABLE			= 1 << 5,
} BonfireMediaType;

const char *
bonfire_burn_action_to_string (BonfireBurnAction action);

typedef enum {
	BONFIRE_TRACK_SOURCE_DEFAULT,
	BONFIRE_TRACK_SOURCE_UNKNOWN,
	BONFIRE_TRACK_SOURCE_SONG,		/* imager */
	BONFIRE_TRACK_SOURCE_INF,		/* recorder */
	BONFIRE_TRACK_SOURCE_AUDIO,		/* recorder */
	BONFIRE_TRACK_SOURCE_DATA,		/* imager */
	BONFIRE_TRACK_SOURCE_DISC,		/* imager */
	BONFIRE_TRACK_SOURCE_CUE,		/* recorder */
	BONFIRE_TRACK_SOURCE_ISO,		/* recorder */
	BONFIRE_TRACK_SOURCE_RAW,		/* recorder */
	BONFIRE_TRACK_SOURCE_IMAGER,		/* used internally for on the fly burning */
	BONFIRE_TRACK_SOURCE_GRAFTS,		/* used internally mostly + must be local files */
	BONFIRE_TRACK_SOURCE_ISO_JOLIET,	/* used internally mostly */
} BonfireTrackSourceType;

typedef struct _BonfireImager BonfireImager;

struct _BonfireTrackSource {
	BonfireTrackSourceType type;

	union {
		struct {
			char *label;
			GSList *grafts;		/* BonfireGraftPt *graft */
			GSList *excluded;		/* list of uris (char*) that are to be always excluded */
		} data;
		struct {
			char *label;
			char *grafts_path;
			char *excluded_path;
		} grafts;
		struct {
			char *album;
			GSList *files;			/* BonfireSongFile *file */
		} songs;
		struct {
			GSList *files;
		} audio;
		struct {
			GSList *files;			/* char *path_to_inf */
		} inf;
		struct {
			NautilusBurnDrive *disc;
			BonfireTrackSourceType target;
		} drive;
		struct {
			char *image;
			char *toc;
		} cue;
		struct {
			char *image;
		} iso;
		struct {
			char *image;
			char *toc;
		} raw;
		struct {
			BonfireImager *obj;
		} imager;
			
	} contents;
};
typedef struct _BonfireTrackSource BonfireTrackSource;

void
bonfire_track_source_free (BonfireTrackSource *source);
BonfireTrackSource *
bonfire_track_source_copy (const BonfireTrackSource *source);

struct _BonfireGraftPt {
	char *uri;
	char *path;
	GSList *excluded; /* list of uris (char *) that are to be excluded only for this path */
};
typedef struct _BonfireGraftPt BonfireGraftPt;

void
bonfire_graft_point_free (BonfireGraftPt *graft);
BonfireGraftPt *
bonfire_graft_point_copy (BonfireGraftPt *graft);

struct _BonfireSongFile {
	char *title;
	char *artist;
	char *composer;
	int isrc;
	char *uri;

	gboolean gap;
};
typedef struct _BonfireSongFile BonfireSongFile;

#ifdef __cplusplus
}
#endif

#endif /* _BURN-BASICS_H */
 
