/***************************************************************************
 *            bonfire-project-manager.h
 *
 *  mer mai 24 14:22:56 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BONFIRE_PROJECT_MANAGER_H
#define BONFIRE_PROJECT_MANAGER_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtknotebook.h>
#include <gtk/gtkuimanager.h>

G_BEGIN_DECLS

#define BONFIRE_TYPE_PROJECT_MANAGER         (bonfire_project_manager_get_type ())
#define BONFIRE_PROJECT_MANAGER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_PROJECT_MANAGER, BonfireProjectManager))
#define BONFIRE_PROJECT_MANAGER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_PROJECT_MANAGER, BonfireProjectManagerClass))
#define BONFIRE_IS_PROJECT_MANAGER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_PROJECT_MANAGER))
#define BONFIRE_IS_PROJECT_MANAGER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_PROJECT_MANAGER))
#define BONFIRE_PROJECT_MANAGER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_PROJECT_MANAGER, BonfireProjectManagerClass))

typedef struct BonfireProjectManagerPrivate BonfireProjectManagerPrivate;

typedef struct {
	GtkNotebook parent;
	BonfireProjectManagerPrivate *priv;
} BonfireProjectManager;

typedef struct {
	GtkNotebookClass parent_class;	
} BonfireProjectManagerClass;

GType bonfire_project_manager_get_type ();
GtkWidget *bonfire_project_manager_new ();

void
bonfire_project_manager_audio (BonfireProjectManager *manager);
void
bonfire_project_manager_data (BonfireProjectManager *manager);
void
bonfire_project_manager_copy (BonfireProjectManager *manager);
void
bonfire_project_manager_iso (BonfireProjectManager *manager, const char *uri);
void
bonfire_project_manager_open (BonfireProjectManager *manager, const char *uri);
void
bonfire_project_manager_empty (BonfireProjectManager *manager);

void
bonfire_project_manager_register_menu (BonfireProjectManager *manager,
				       GtkUIManager *ui_manager);

#endif /* BONFIRE_PROJECT_MANAGER_H */
