/***************************************************************************
 *            async-job-manager.h
 *
 *  ven avr  7 14:39:35 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef ASYNC_JOB_MANAGER_H
#define ASYNC_JOB_MANAGER_H

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define BONFIRE_TYPE_ASYNC_JOB_MANAGER         (bonfire_async_job_manager_get_type ())
#define BONFIRE_ASYNC_JOB_MANAGER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_ASYNC_JOB_MANAGER, BonfireAsyncJobManager))
#define BONFIRE_ASYNC_JOB_MANAGER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_ASYNC_JOB_MANAGER, BonfireAsyncJobManagerClass))
#define BONFIRE_IS_ASYNC_JOB_MANAGER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_ASYNC_JOB_MANAGER))
#define BONFIRE_IS_ASYNC_JOB_MANAGER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_ASYNC_JOB_MANAGER))
#define BONFIRE_ASYNC_JOB_MANAGER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_ASYNC_JOB_MANAGER, BonfireAsyncJobManagerClass))

typedef struct BonfireAsyncJobManagerPrivate BonfireAsyncJobManagerPrivate;

typedef gboolean	(*BonfireAsyncRunJob)		(GObject *object, gpointer data);
typedef gboolean	(*BonfireSyncGetResult)	(GObject *object, gpointer data);
typedef void		(*BonfireAsyncDestroy)	(gpointer data);
typedef void		(*BonfireAsyncCancelJob)	(gpointer data);

typedef gboolean	(*BonfireAsyncFindJob)		(gpointer data, gpointer user_data);

typedef struct {
	GObject parent;
	BonfireAsyncJobManagerPrivate *priv;
} BonfireAsyncJobManager;

typedef struct {
	GObjectClass parent_class;
} BonfireAsyncJobManagerClass;

GType bonfire_async_job_manager_get_type ();
BonfireAsyncJobManager *bonfire_async_job_manager_get_default ();

void
bonfire_async_job_manager_cancel_by_object (BonfireAsyncJobManager *manager,
					    GObject *obj);
gboolean
bonfire_async_job_manager_queue (BonfireAsyncJobManager *manager,
				 gint type,
				 gpointer data);
gboolean
bonfire_async_job_manager_find_urgent_job (BonfireAsyncJobManager *manager,
					   gint type,
					   BonfireAsyncFindJob func,
					   gpointer user_data);
gint
bonfire_async_job_manager_register_type (BonfireAsyncJobManager *manager,
					 GObject *object,
					 BonfireAsyncRunJob run,
					 BonfireSyncGetResult results,
					 BonfireAsyncDestroy destroy,
					 BonfireAsyncCancelJob cancel);
void
bonfire_async_job_manager_unregister_type (BonfireAsyncJobManager *manager,
					   gint type);
#endif /* ASYNC_JOB_MANAGER_H */
