// Berkeley Open Infrastructure for Network Computing
// http://boinc.berkeley.edu
// Copyright (C) 2005 University of California
//
// This is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation;
// either version 2.1 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU Lesser General Public License for more details.
//
// To view the GNU Lesser General Public License visit
// http://www.gnu.org/copyleft/lesser.html
// or write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "boinc_db.h"
#include "sched_config.h"
#include "synch.h"
#include "server_types.h"

// various delay params.
// Any of these could be moved into SCHED_CONFIG, if projects need control.

#define DELAY_MISSING_KEY           3600
    // account key missing or invalid
#define DELAY_UNACCEPTABLE_OS       3600*24
    // Darwin 5.x or 6.x (E@h only)
#define DELAY_BAD_CLIENT_VERSION    3600*24
    // client version < config.min_core_client_version
#define DELAY_NO_WORK_SKIP          0
    // no work, config.nowork_skip is set
    // Rely on the client's exponential backoff in this case
#define DELAY_PLATFORM_UNSUPPORTED  3600*24
    // platform not in our DB
#define DELAY_DISK_SPACE            3600
    // too little disk space or prefs (locality scheduling)
#define DELAY_DELETE_FILE           3600*4
    // wait for client to delete a file (locality scheduling)
#define DELAY_ANONYMOUS             3600*4
    // anonymous platform client doesn't have version
#define DELAY_NO_WORK_TEMP          0
    // client asked for work but we didn't send any,
    // because of a reason that could be fixed by user
    // (e.g. prefs, or run BOINC more)
    // Rely on the client's exponential backoff in this case
#define DELAY_NO_WORK_PERM          3600*24
    // client asked for work but we didn't send any,
    // because of a reason not easily changed
    // (like wrong kind of computer)

extern SCHED_CONFIG config;
extern GUI_URLS gui_urls;
extern PROJECT_FILES project_files;
extern key_t sema_key;
extern int g_pid;

extern void send_message(const char*, int delay, bool send_header);
extern int open_database();
