// Berkeley Open Infrastructure for Network Computing
// http://boinc.berkeley.edu
// Copyright (C) 2005 University of California
//
// This is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation;
// either version 2.1 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU Lesser General Public License for more details.
//
// To view the GNU Lesser General Public License visit
// http://www.gnu.org/copyleft/lesser.html
// or write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


// interfaces for accessing sempahores

#include "config.h"
#include <cstdio>
#include <cstring>

#include "error_numbers.h"
#include "synch.h"

#ifdef _USING_FCGI_
#include "fcgi_stdio.h"
#endif

union SEMUN {
    int val;
    struct semid_ds *buf;
    unsigned short int *arra;
    struct seminfo *__buf;
};

int create_semaphore(key_t key){
    int id, retval;
    SEMUN s;

    id = semget(key, 1, IPC_CREAT|IPC_EXCL|0777);
    if (id < 0) {
        return ERR_SEMGET;
    }
    memset(&s, 0, sizeof(s));
    s.val = 1;
    retval = semctl(id, 0, SETVAL, s);
    if (retval) {
        return ERR_SEMCTL;
    }
    return 0;
}

int destroy_semaphore(key_t key){
    int id, retval;
    id = semget(key, 0, 0);
    if (id < 0) {
        return ERR_SEMGET;
    }
    retval = semctl(id, 1, IPC_RMID, 0);
    if (retval) {
        return ERR_SEMCTL;
    }
    return 0;
}

int lock_semaphore(key_t key) {
    struct sembuf s;
    int id, retval;

    id = semget(key, 0, 0);
    if (id < 0) {
        return ERR_SEMGET;
    }
    s.sem_num = 0;
    s.sem_op = -1;
    s.sem_flg = SEM_UNDO;
    retval = semop(id, &s, 1);
    if (retval) {
        return ERR_SEMOP;
    }
    return 0;
}

int unlock_semaphore(key_t key) {
    struct sembuf s;
    int id, retval;

    id = semget(key, 0, 0);
    if (id < 0) {
        return ERR_SEMGET;
    }
    s.sem_num = 0;
    s.sem_op = 1;
    s.sem_flg = SEM_UNDO;
    retval = semop(id, &s, 1);
    if (retval) {
        return ERR_SEMOP;
    }
    return 0;
}

int get_key(char* path, int id, key_t& key) {
    key = ftok(path, id);
    if (key == (key_t)-1) return ERR_FTOK;
    return 0;
}

const char *BOINC_RCSID_9412b586d1 = "$Id: synch.C,v 1.13 2005/11/21 18:34:29 korpela Exp $";
