// Utils.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef UTILS_H
#define UTILS_H

#include <time.h>
#include "String.H"
#include "Bot.H"

#ifdef USESCRIPTS
extern "C" {
#include <guile/gh.h>
}
#endif

class Utils {
public:
  static String getNick(String);
  static String getUserhost(String);
  static String getKey();
  static String makeWildcard(String);

  static bool isChannel(String);
  static bool isWildcard(String);
  static bool isValidChannelName(String);
  static bool isValidNickName(String);
  static bool isIP(String);

  static int getLevel(Bot *, String);
  static int getLevel(Bot *, String, String);

  static String levelToStr(int);
  static String protToStr(int);
  static String boolToStr(bool);

  static time_t strToTime(String);

#ifdef USESCRIPTS
  static String scm2String(SCM);
  static SCM string2SCM(String);
#endif
};

#endif
