//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LAST_FM_RECOMMEND_HH
#define BMP_LAST_FM_RECOMMEND_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include "bmp/types/types-ui.hh"
#include "bmp/types/types-library.hh"
#include "bmp/types/types-basic.hh"
#include "bmp/types/types-lastfm.hh"

#include <glibmm/markup.h>
#include <glibmm/ustring.h>
#include <gtkmm.h>
#include <libglademm.h>

#include "lastfm.hh"

using namespace Glib;

namespace Bmp
{
  namespace LastFM
  {
    class RecommendDialog
      : public Gtk::Dialog
    {
        TrackMetadata m_item;

      public:

        RecommendDialog (BaseObjectType*                        cobject,
                         RefPtr<Gnome::Glade::Xml> const& xml);
        ~RecommendDialog ();
        static RecommendDialog* create ();
        void run (TrackMetadata const& item);

      private:

        struct CR : public Gtk::TreeModel::ColumnRecord
        {
            Gtk::TreeModelColumn<RefPtr<Gdk::Pixbuf> > avatar;
            Gtk::TreeModelColumn<ustring>              name;
            Gtk::TreeModelColumn<ustring>              username;
            CR()
            {
              add (avatar);
              add (name);
              add (username);
            }
        };
        CR cr;

        RefPtr<Gnome::Glade::Xml>           m_ref_xml;
        RefPtr<Gtk::ListStore>              m_store;
        Gtk::TreeView                     * m_view;
        Gtk::Notebook                     * m_notebook;
        Gtk::Entry                        * e_artist, * e_album, * e_title;
        Gtk::Label                        * l_artist, * l_album, * l_title;
        Gtk::ComboBox                     * m_recommend_cbox;
        Gtk::TextView                     * m_notes_view;

        void recommend_changed ();
        void recommend ();
        void update_view ();

        int sort_func (Gtk::TreeIter const& i1,
                       Gtk::TreeIter const& i2);
    };
  } // namespace LastFM
} // namespace Bmp

#endif // !BMP_LAST_FM_RECOMMEND_DIALOG_HH

