//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_SIMPLE_PROGRESS_HH
#define BMP_SIMPLE_PROGRESS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glib/gtypes.h>
#include <glibmm/ustring.h>
#include <gtkmm/dialog.h>
#include <gtkmm/progressbar.h>
#include <libglademm/xml.h>

namespace Bmp
{
    class SimpleProgress
      : public Gtk::Dialog
    {
      public:

        typedef sigc::signal<void> SignalCancel;

        SimpleProgress (BaseObjectType                       * obj,
                        Glib::RefPtr<Gnome::Glade::Xml> const& xml);
        static SimpleProgress * create ();
        ~SimpleProgress () {}

        void set_label (Glib::ustring const& title);

        void step (guint64 n_items, guint64 nth_item);
        void percentage (double p);

        void done (bool wait_for_close = true);

        bool canceled () const;
        void enable_cancel ();

        SignalCancel & signal_cancel () { return s_cancel_; }

    protected:

        virtual bool on_delete_event (GdkEventAny*);

      private:

        SignalCancel s_cancel_;

        void on_cancel ();  

        Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;
        Gtk::ProgressBar * m_progress;
        bool m_canceled;
    };
}
#endif // !BMP_SIMPLE_PROGRESS_HH
