//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif // HAVE_CONFIG_H

#include <glibmm.h>
#include <vector>
#include <map>
#include <boost/algorithm/string.hpp>
#include <glib.h>

#include "debug.hh"

namespace Bmp
{
  namespace
  {
    typedef std::vector<std::string> StringList;
    std::map<std::string, bool> debug_domains;

    bool use_debug = false;
    bool all_debug = false;

  } // anonymous namespace

  void
  debug_init ()
  {
    using boost::algorithm::split;
    using boost::algorithm::is_any_of;

    const char *debug_env = g_getenv ("BMP_DEBUG");

    if( debug_env && !strcmp(debug_env,"*")) 
    {
        all_debug = true;
    }
    else
    if( debug_env )
    {
        use_debug = true;
        StringList subs;
        split (subs, debug_env, is_any_of (":"));

        for (StringList::const_iterator iter = subs.begin (), end = subs.end ();
             iter != end;
             ++iter)
        {
            debug_domains[*iter] = true;
        }
    }
  }

  void
  debug (const std::string &domain,
         const std::string &format,
         ...)
  {
      if( !use_debug )
        return;

      if( debug_domains.count(domain) || all_debug ) 
      {
          va_list args;

          va_start (args, format);
          std::string domain_full = std::string("bmpx-") + domain;
          g_logv (domain_full.c_str (), G_LOG_LEVEL_INFO, format.c_str (), args);
          va_end (args);
      }
  }
} // Bmp namespace
