//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_TOOLBOX_HH
#define BMP_UI_TOOLBOX_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <string>
#include <glibmm/ustring.h>

#include <gtk/gtk.h>
#include <cairomm/context.h>

#include <gdkmm/color.h>
#include <gdkmm/colormap.h>
#include <gdkmm/drawable.h>
#include <gdkmm/pixbuf.h>
#include <gdkmm/screen.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/widget.h>
#include <gtkmm/window.h>

namespace Bmp
{
  namespace Util
  {
    GtkWidget*
    ui_manager_get_popup (GtkUIManager * self,
                          char const*    path);

    Gtk::Widget*
    get_popup (Glib::RefPtr<Gtk::UIManager> ui_manager, Glib::ustring const& menupath);

    void
    window_set_busy      (GtkWindow* window);

    void
    window_set_idle      (GtkWindow* window);

    void
    window_set_busy      (Gtk::Window & window);

    void
    window_set_idle      (Gtk::Window & window);

    void
    window_set_icon_list (Gtk::Window & window,
                          std::string const& icon_name);

    double
    screen_get_resolution   (Glib::RefPtr<Gdk::Screen> const& screen);

    double
    screen_get_x_resolution (Glib::RefPtr<Gdk::Screen> const& screen);

    double
    screen_get_y_resolution (Glib::RefPtr<Gdk::Screen> const& screen);

    void
    check_alpha ();

    bool
    has_alpha ();

    Glib::RefPtr<Gdk::Colormap>
    get_rgba_colormap();

    void
    style_save (GtkWidget * widget);

    GtkStyle*
    style_get ();

    void
    color_to_rgba (Gdk::Color const& color,
                   double&           r,
                   double&           g,
                   double&           b,
                   double&           a);

    Cairo::RefPtr<Cairo::ImageSurface>
    cairo_image_surface_from_pixbuf (Glib::RefPtr<Gdk::Pixbuf> pixbuf);

    void
    cairo_rounded_rect (Cairo::RefPtr<Cairo::Context>& cr,
                        double                         x,
                        double                         y,
                        double                         width,
                        double                         height,
                        double                         radius);

    Cairo::RefPtr<Cairo::ImageSurface>
    cairo_image_surface_scale (Cairo::RefPtr<Cairo::ImageSurface> source, double width, double height);

    Cairo::RefPtr<Cairo::ImageSurface>
    cairo_image_surface_round (Cairo::RefPtr<Cairo::ImageSurface> source, double radius);

    void 
    cairo_image_surface_border (Cairo::RefPtr<Cairo::ImageSurface> & source, double width);

  } // Util
} // Bmp

#endif // UI_TOOLBOX_HH
