//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_STREAMS_SHOUTCAST_HH
#define BMP_STREAMS_SHOUTCAST_HH

#include <list>

#include <glibmm/ustring.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treemodelfilter.h>
#include <gtkmm/treeview.h>
#include <libglademm/xml.h>
#include <sigc++/signal.h>
#include "minisoup.hh"
#include "xml.hh"

namespace Bmp
{
  namespace Streams
  {
    struct StreamInfo
    {
      Glib::ustring   name;
      unsigned int    bitrate;
      Glib::ustring   genre;
      Glib::ustring   uri;
      StreamInfo () : name (""), bitrate (0), genre (""), uri ("") {}
    };
    typedef std::list<StreamInfo> StreamList;

    typedef sigc::signal <void, StreamList const&> SignalListUpdated;
    typedef sigc::signal <void> SignalStartStop;

    namespace Shoutcast
    {
      class Streams
        : public Gtk::TreeView
      {
        private:

          class Columns
            : public Gtk::TreeModel::ColumnRecord
          {
            public:

              Gtk::TreeModelColumn<Glib::ustring> name;
              Gtk::TreeModelColumn<unsigned int>  bitrate;
              Gtk::TreeModelColumn<Glib::ustring> genre;
              Gtk::TreeModelColumn<Glib::ustring> uri;

              Columns ()
              {
                add (name);
                add (bitrate);
                add (genre);
                add (uri);
              }
          };
          Columns columns;

          bool visible (Gtk::TreeIter const& iter);
          void column_clicked (int column);

          Glib::RefPtr<Gtk::ListStore>        m_streams;
          Glib::RefPtr<Gtk::TreeModelFilter>  m_filtered;
          Glib::ustring                       m_filter;

        public:

          Streams (BaseObjectType                       * obj,
                   Glib::RefPtr<Gnome::Glade::Xml> const& xml);
          virtual ~Streams () {}

          void filter (Glib::ustring const& filter);
          void set_streams (StreamList const& list);
          void get_stream (Glib::ustring& title, Glib::ustring& uri);

      }; // !Streams

      class Genres
        : public Gtk::TreeView
      {

        public:

          Genres (BaseObjectType                       * obj,
                  Glib::RefPtr<Gnome::Glade::Xml> const& xml);

          virtual ~Genres ()
          {
            g_hash_table_destroy (m_cache);
          }

          void refresh (bool force = false);

          SignalListUpdated&
          s_list_updated ()
          {
            return s_list_updated_;
          }

          SignalStartStop&
          s_start ()
          { return s_start_; }

          SignalStartStop&
          s_stop ()
          {
            return s_stop_;
          }

        protected:

          void on_row_activated (Gtk::TreeModel::Path const& path, Gtk::TreeViewColumn * column);

        private:

          SignalListUpdated s_list_updated_;
          SignalStartStop   s_start_;
          SignalStartStop   s_stop_;

          class Columns
            : public Gtk::TreeModel::ColumnRecord
          {
            public:
              Gtk::TreeModelColumn<Glib::ustring> name;
              Columns ()
              {
                add (name);
              }
          };

          Columns genres;

          void  genre_cell_data (Gtk::CellRenderer *cell, Gtk::TreeIter const& iter);

          void  build_genre_list ();

          void  refresh_wrapper ();
          void  refresh_parse_and_emit_updated (xmlDocPtr doc);
          void  refresh_callback (char const* data, guint size, guint code, std::string const& genre);

          Glib::RefPtr<Gtk::ListStore> m_genres;
          Gtk::TreeModel::iterator m_current_selected_iter;
          GHashTable* m_cache;
          StreamList m_stream_list;
          Soup::RequestRefP  m_refresh_request; 

      }; // end class Genres
    } // end namespace Shoutcast
  } // end namespace Streams
} // end namespace Bmp

#endif // !BMP_STREAMS_SHOUTCAST_HH
