//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_PODCAST_TYPES_HH 
#define BMP_PODCAST_TYPES_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <string>
#include <vector>

#include <glibmm/ustring.h>
#include <bmp/base-types.hh>

using namespace Glib;

namespace Bmp
{
  namespace PodcastBackend
  {
    struct PodcastOverlayItem
    {
      bool        played;
      bool        downloaded;
      std::string filename;

      PodcastOverlayItem ()
        : played (false),
          downloaded  (false)
      {}

    };

    struct PodcastItem
      : public PodcastOverlayItem
    {
      PodcastItem (PodcastOverlayItem const& overlay)
      {}

      PodcastItem ()
      {}

      void
      overlay (PodcastOverlayItem const& overlay)
      {
        this->downloaded  = overlay.downloaded;
        this->played      = overlay.played;
        this->filename    = overlay.filename;
      }

      // Item General Attributes
      ustring       title;
      ustring       description;
      ustring       pub_date;
      time_t        pub_date_unix;

      ustring       link;
      ustring       copyright;
      ustring       category;

      // Enclosure (Stream)
      ustring       enclosure_url;
      ustring       enclosure_type;
      unsigned int  enclosure_length;

      // GUID
      bool          uid_permalink;
      ustring       uid_value;
    };

    typedef std::map <std::string, PodcastOverlayItem>  PodcastOverlayItemsMap;
    typedef std::map <std::string, PodcastItem>  PodcastItemsMap;

    struct Podcast 
    {
      Podcast (std::string const& uuid)
        : ttl               (0)
        , cast_uuid         (uuid)
        , last_poll_time    (0)
        , most_recent_item  (0)
      {}

      Podcast ()
        : ttl               (0)
        , last_poll_time    (0)
        , most_recent_item  (0)
      {}

      // Podcast
      ustring   title;
      ustring   link;
      ustring   description;
      ustring   language;
      time_t    ttl;

      ustring   copyright;
      ustring   pub_date;
      ustring   category;

      // Image (Optional)
      ustring  image_url;
      ustring  image_title;
      ustring  image_link;
      ustring  image_description;
      ustring  itunes_image_url;

      // Our own data
      std::string cast_uuid;
      std::string uri;
      time_t      last_poll_time;
      time_t      most_recent_item;

      PodcastItemsMap items;
    };

    typedef std::vector <std::string>           PodcastList;
    typedef std::map    <std::string, Podcast>  PodcastMap;

    struct PodcastOverlayParseContext
    {
      Podcast                 const&  m_cast;
      PodcastOverlayItemsMap       &  m_overlays;

      PodcastOverlayParseContext (Podcast const& cast, PodcastOverlayItemsMap & overlays)
      : m_cast      (cast)
      , m_overlays  (overlays)
      {}
    };

  }
}
#endif
