//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UTIL_STRING_HH
#define BMP_UTIL_STRING_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <string>
#include <map>
#include <vector>

#include <glibmm.h>
#include <bmp/base_types.hh>

namespace Bmp
{
  namespace Util
  {
    bool str_has_prefix_nocase    (const char *, const char*);
    bool str_has_suffix_nocase    (const char *, const char*);
    bool str_has_suffixes_nocase  (const char *, char* const *);
    bool str_has_suffixes_nocase_on_crack (std::string const&, StrV const&);

    std::string md5_hex     (char* const, size_t);
    std::string get_timestr (time_t, int);
    std::string get_time    ();
  }
}

#endif //!BMP_UTIL_STRING_HH
