//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_TOOLBOX_HH
#define BMP_UI_TOOLBOX_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdkmm/drawable.h>
#include <gdkmm/pixbuf.h>
#include <gdkmm/screen.h>
#include <gdkmm/colormap.h>
#include <gtkmm/window.h>
#include <cairomm/context.h>

namespace Bmp
{
  namespace Util
  {
    GtkWidget * ui_manager_get_popup (GtkUIManager * self,
                                      char const*    path);

    void window_set_busy      (GtkWidget *   widget);
    void window_set_idle      (GtkWidget *   widget);
    void window_set_icon_list (GtkWidget *   window,
                               char const*   icon_name);
    void window_set_busy      (Gtk::Window & window);
    void window_set_idle      (Gtk::Window & window);

#ifdef ENABLE_NLS
    char * menu_translate (char const* message,
                           gpointer    data);
#endif

    double screen_get_resolution   (Glib::RefPtr<Gdk::Screen> const& screen);
    double screen_get_x_resolution (Glib::RefPtr<Gdk::Screen> const& screen);
    double screen_get_y_resolution (Glib::RefPtr<Gdk::Screen> const& screen);

    void check_alpha ();
    bool has_alpha ();
    Glib::RefPtr<Gdk::Colormap> get_rgba_colormap();
    void style_save (GtkWidget * widget);
    GtkStyle * style_get ();

    void color_to_rgba (Gdk::Color const& color,
                        double &          r,
                        double &          g,
                        double &          b,
                        double &          a);

    // NOTE: gtkmm has no binding for gdk_cairo_create ()
    Cairo::RefPtr<Cairo::Context> create_gdk_cairo_context (Glib::RefPtr<Gdk::Drawable> const& drawable);

    // NOTE: gtkmm has no binding for gdk_cairo_set_source_pixbuf ()
    void set_cairo_source_pixbuf (Cairo::RefPtr<Cairo::Context> &  cr,
                                  Glib::RefPtr<Gdk::Pixbuf> const& pixbuf,
                                  double                           x,
                                  double                           y);

    // NOTE: gtkmm has no binding for gdk_cairo_set_source_color ()
    void set_cairo_source_color  (Cairo::RefPtr<Cairo::Context> & cr,
                                  Gdk::Color const&               color,
                                  double                          alpha = 1.);

  } // !Util::

} // !Bmp::

#endif
