//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <gtkmm.h>
#include <glibmm.h>
#include <libglademm.h>

#include "main.hh"
#include "paths.hh"
#include "stock.hh"
#include "network.hh"

#include "ui-part-icecast-streams.hh"
#include "streams-icecast.hh"

#include "x_play.hh"
#include "x_vfs.hh"

namespace
{
  void
  on_icecast_filter_changed (Bmp::Streams::Icecast *icecast, Gtk::Entry *entry)
  {
    icecast->filter (entry->get_text());
  }
}

namespace Bmp
{
  namespace UiPart
  {

    guint
    IcecastStreams::add_ui ()
    {
      return 0;
    };

    IcecastStreams::IcecastStreams (Glib::RefPtr<Gnome::Glade::Xml> const& xml, Glib::RefPtr<Gtk::UIManager> ui_manager)

         : Base (xml, ui_manager) 

    {
      if (!Network::check_host("dir.xiph.org"))
        {
          m_ref_xml->get_widget ("vbox-icecast")->set_sensitive (false);
          return;
        }

      dynamic_cast<Gtk::Image *>(m_ref_xml->get_widget ("throbber-icecast"))->set
          (Glib::build_filename (BMP_IMAGE_DIR,BMP_THROBBER));

      m_ref_xml->get_widget_derived ("icecast-streams", icecast);

      Gtk::Entry *entry = dynamic_cast<Gtk::Entry *>(m_ref_xml->get_widget ("icecast-filter"));
      entry->signal_changed().connect (sigc::bind (sigc::ptr_fun (&on_icecast_filter_changed), icecast, entry));

      icecast->get_selection()->signal_changed().connect
            (sigc::mem_fun (this, &Bmp::UiPart::IcecastStreams::selection_changed));
      icecast->signal_row_activated().connect
            (sigc::mem_fun (this, &Bmp::UiPart::IcecastStreams::activate_default));

      dynamic_cast<Gtk::Button *>(m_ref_xml->get_widget( "b_icecast_refresh" ))->signal_clicked().connect
            (sigc::bind (sigc::mem_fun (this, &Bmp::UiPart::IcecastStreams::refresh),
                         dynamic_cast<Gtk::Notebook *>(m_ref_xml->get_widget ("notebook-icecast"))));
    }

    void  
    IcecastStreams::refresh (Gtk::Notebook *notebook)
    {
      notebook->set_current_page (1);
      m_ref_xml->get_widget ("vbox-icecast")->set_sensitive (false);
      while (gtk_events_pending()) gtk_main_iteration();

      icecast->refresh();

      m_ref_xml->get_widget ("vbox-icecast")->set_sensitive (true);
      notebook->set_current_page (0);
      while (gtk_events_pending()) gtk_main_iteration();
    }

    void
    IcecastStreams::activate_default (Gtk::TreeModel::Path const& path, Gtk::TreeViewColumn* column)
    {
      dynamic_cast<Gtk::Window *>(m_ref_xml->get_widget ("main-ui"))->activate_default ();
    }

    void
    IcecastStreams::play_set_title (const char *title)
    {
      m_current_title = title;
      Glib::ustring _title;

      SimpleTrackInfo sti;

      sti.artist = m_current_name;
      sti.title = m_current_title;
      _title  .append (Glib::Markup::escape_text (m_current_title.get()))
              .append (" (<i>")
              .append (Glib::Markup::escape_text (m_current_name.get())
              .append ("</i>)"));

      s_track_info_.emit (_title, sti); 
    }

    void
    IcecastStreams::selection_changed ()
    {
      // Playbacksource
      if (icecast->get_selection ()->count_selected_rows() == 1)
          m_caps = Caps (m_caps |  PlaybackSource::CAN_PLAY);
      else
          m_caps = Caps (m_caps & ~PlaybackSource::CAN_PLAY);
      s_caps_.emit (m_caps);
    }

    Glib::ustring
    IcecastStreams::get_uri ()
    {
      return m_current_uri.get();
    }

    bool
    IcecastStreams::go_next ()
    {
      return false;
    }

    bool
    IcecastStreams::go_prev ()
    {
      return false;
    }

    void
    IcecastStreams::stop ()
    {
      title_conn.disconnect ();
      ::play->property_lastfm_mode() = false;

      if (m_current_title) m_current_title.reset();
      if (m_current_uri)   m_current_uri.reset();

      m_caps = Caps (m_caps & ~PlaybackSource::CAN_PAUSE);
      s_caps_.emit (m_caps); 
    }

    void
    IcecastStreams::play ()
    {
      using namespace Glib;

      ::play->property_lastfm_mode() = false;
      title_conn = ::play->signal_title().connect
            (sigc::mem_fun (this, &Bmp::UiPart::IcecastStreams::play_set_title));

      ustring name, uri;
      icecast->get_stream (name, uri);

      m_current_name = name; 
      m_current_uri = uri; 
      m_current_title = uri; 

      play_set_title (m_current_title.get().c_str());
      m_caps = Caps (m_caps | PlaybackSource::CAN_PAUSE);
      s_caps_.emit (m_caps); 
    }

    void
    IcecastStreams::restore_context ()
    {
    }
  }
}
