#include "includes.h"

void list(struct struc_bootmanager *btmgr)
{
    int i;

    if (btmgr->sbmkdata.kernel_flags & KNLFLAG_NOINT13EXT)
	printf("The SBM won't use INT 13 Extension\n");
    else
	printf("The SBM will use INT 13 Extension\n");
    if (btmgr->sbmkdata.kernel_flags & KNLFLAG_REMLAST)
	printf("The SBM use as default as the last used boot record\n");
    if (btmgr->sbmkdata.kernel_flags & KNLFLAG_SECURITY)
	printf("The kernel is in security lock mode\n");
    if ((btmgr->sbmkdata.kernel_flags & KNLFLAG_FIRSTRUN) && 
	(!(btmgr->sbmkdata.kernel_flags & KNLFLAG_NOAUTOSCAN)))
	printf("The SBM will reread all hard drives next startup\n");
    if (btmgr->sbmkdata.root_password)
	printf("The boot manager is guarded by a ROOT PASSWORD\n");
    if (btmgr->sbmkdata.direct_boot_record!=255)
	printf("After next startup the %d. record will be started instead of default\n", btmgr->sbmkdata.direct_boot_record+1);
    printf("Additional CD IO-ports: 0x%.4x; 0x%.4x\n", btmgr->sbmkdata.cdrom_ioports[0], btmgr->sbmkdata.cdrom_ioports[1]);
    switch (btmgr->sbmkdata.bootmenu_style)
    {
	case 0:
	    printf("The boot menu style is show all\n");
	    break;
	case 1:
	    printf("The boot menu style is hide Flags\n");
	    break;
	case 2:
	    printf("The boot menu style is hide Flags and Name\n");
	    break;
	case 3:
	    printf("The boot menu style is show only Name\n");
	    break;
	    
    }
    printf("The delay time: %d\n\n", btmgr->sbmkdata.delay_time);
    printf("The menuitems: \n");
    printf("%-4s %3s %6s %16s %20s %s\n","ID","DRV","PART","NAME","TYPE", "PROPERITIES");
    for (i=0 ; i<MAX_RECORD_NUM ; i++)
    {
        if (reccheck(btmgr->sbmkdata.boot_records[i]))
	{
    	    printf("%2d.  %3s %6s %16s %20s", i+1,
              drvidtostring(btmgr->sbmkdata.boot_records[i].drive_id), 
              partidtostring(btmgr->sbmkdata.boot_records[i].part_id), 
	      btmgr->sbmkdata.boot_records[i].name,
              (btmgr->sbmkdata.boot_records[i].type) ? 
	      typetostring(btmgr->sbmkdata.boot_records[i].type) :
	      "Disk driver");
	    if (i==btmgr->sbmkdata.default_record)
		printf(" DEF");
	    if (btmgr->sbmkdata.boot_records[i].flags & INFOFLAG_AUTOACTIVE)
		printf(" AACT");
	    if (btmgr->sbmkdata.boot_records[i].flags & INFOFLAG_AUTOHIDE)
		printf(" AHID");
	    if (btmgr->sbmkdata.boot_records[i].password)
		printf(" PASS");
	    if (btmgr->sbmkdata.boot_records[i].flags & INFOFLAG_HAVEKEYS)
		printf(" KEYS");
	    if (btmgr->sbmkdata.boot_records[i].flags & INFOFLAG_SWAPDRVID)
		printf(" SWP");
	    if (btmgr->sbmkdata.boot_records[i].flags & INFOFLAG_SCHEDULED)
	    {
		unsigned short begin=0;
		unsigned int tmpl;
		unsigned short end=0;
		unsigned short day=0;
		
		tmpl=btmgr->sbmkdata.boot_records[i].schedule_time;
		begin=tmpl & 0xFFF;
		end=(tmpl>>12) & 0xFFF;
		day=(tmpl>>24) & 0xFF;
		if (day==0)
		{
		    printf(" SCHE\n \\--This record is the default between %.2d:%.2d and %.2d:%.2d all days.",
			   begin/60,
		           begin%60,
		           end/60,
		           end%60);
		}
		else
		{
		    printf(" SCHE\n \\--This record is the default between %.2d:%.2d and %.2d:%.2d on days:\n \\--",
			   begin/60,
		           begin%60,
		           end/60,
		           end%60);
		    if (day&1) printf(" Sunday");
		    if (day&2) printf(" Monday");
		    if (day&4) printf(" Tuesday");
		    if (day&8) printf(" Wednesday");
		    if (day&16) printf(" Thursday");
		    if (day&32) printf(" Friday");
		    if (day&64) printf(" Saturday");
		    printf("\n");
		}
	    }
	    printf("\n");
	}
    }
}
