/*
 * sbminst.c
 *
 * the installation program for Smart BootManager
 * 
 * this program only supports Linux and DOS.
 *
 * Copyright (C) 2000, Suzhe, Lonius  See file COPYING for details.
 * 
 * Modified for configurator-installator. Now it only supports linux.
 * Copyright (C) 2000, Risko Gergely under the GPL. 
*/
#include "includes.h"
#include "install.h"
#include "bins/loader.h"
#include "bins/main.h"

#include "bins/theme-fr.h"
#include "bins/theme-es.h"
#include "bins/theme-cz.h"
#include "bins/theme-ru.h"
#include "bins/theme-hu.h"
#include "bins/theme-de.h"
#include "bins/theme-us.h"
#include "bins/theme-zh.h"

char *theme_names[]= { "us", "zh", "de", "hu", "ru", "cz", "es", "fr", NULL };
char *theme_pointers[]= {
	theme_us_code,
	theme_zh_code,
	theme_de_code,
	theme_hu_code,
	theme_ru_code,
	theme_cz_code,
	theme_es_code,
	theme_fr_code,
	NULL
};

char *inst_dev;

int knl_tsize;
FILE *bk_fp, *ui_fp;
byte buf_ldr[SECTOR_SIZE + 1], buf_knl[MAX_SBM_SIZE];
byte buf_theme[MAX_THEME_SIZE];
byte *theme_code;

int always_yes;

struct struc_sbml_header *p_loader;
struct struc_sbmk_header *p_knl;
struct struc_sbmt_header *p_theme;

void
init_settings ()
{
  knl_tsize = 0;		/* kernel part total size */
  bk_fp = NULL;
  ui_fp = NULL;
  theme_code = theme_us_code;
  always_yes = 0;
}

void
die (char *fmt, ...)
{
  va_list ap;
  va_start (ap, fmt);
  vfprintf (stderr, fmt, ap);
  va_end (ap);
  fprintf (stderr, "\n");
  exit (-1);
}

void install_params (char * themename, char *themesdir, char *drive, unsigned char drivenum)
{
  int theme_size, fn;
  FILE *theme_fp;

  for( fn=0; theme_names[fn]!=NULL; fn++ )
     if( strcasecmp (themename, theme_names[fn]) == 0 )
	break;

  if( theme_names[fn] != NULL )
    theme_code = theme_pointers[fn];
  else
    {
      if ((theme_fp = fopen (themename, "rb")) == NULL)
      {
          char * themenamedir;
	  
	  asprintf(&themenamedir, "%s/%s", themesdir, themename);
          if ((theme_fp = fopen (themenamedir, "rb")) == NULL)
	    die ("fopen %s: %s", themenamedir, strerror (errno));
	  free(themenamedir);
      }
      fseek (theme_fp, 0, SEEK_END);
      theme_size = ftell (theme_fp);
      rewind (theme_fp);
      if (fread (buf_theme, (theme_size > MAX_THEME_SIZE) ? MAX_THEME_SIZE : theme_size,
	  1, theme_fp) < 1)
	    die ("fread %s: %s", themename, strerror (errno));
      theme_code = buf_theme;
      fclose (theme_fp);
    }
  
  inst_dev=drive;
}

int
open_blk_dev (char *dev)
{
  int devd, major, minor;
  struct stat st;

  if ((devd = open (dev, O_RDWR)) < 0)
    die ("open %s: %s", dev, strerror (errno));
  if (fstat (devd, &st) < 0)
    die ("stat %s: %s", dev, strerror (errno));
  if (!S_ISBLK (st.st_mode))
    die ("%s is not a block device!\n", dev);

/* Check device */
  major = MAJOR (st.st_rdev);
  minor = MINOR (st.st_rdev);

  if (major != MAJOR_FD && 
      major != MAJOR_HD1 && 
      major != MAJOR_HD2 &&
      major != MAJOR_HD3 &&
      major != MAJOR_HD4 &&
      major != MAJOR_SD)
    die ("device %s not supported in this version.", dev);


  if ( ((major == MAJOR_HD1 || major == MAJOR_HD2|| 
       major == MAJOR_HD3 || major == MAJOR_HD4) && minor % 64 != 0) ||
       (major == MAJOR_SD && minor % 16 !=0 ) )
    die ("device %s is a partition!", dev);

  return devd;
}

void
close_blk_dev (int *dev_d)
{
  sync ();
  if (close (*dev_d) < 0)
    die ("close %s : %s", inst_dev, strerror (errno));
  *dev_d = 0;
}

void
proc_knl ()
{
  int devd;
  struct struc_sbmk_data *p_knl_data;

  p_knl_data = & ( ((struct struc_sbmk *)p_knl)->data );

  devd = open_blk_dev (inst_dev);

  memcpy (buf_knl, main_code, p_knl->kernel_size);
  memcpy (buf_knl + p_knl->kernel_size, theme_code, p_theme->size);

  p_knl = (struct struc_sbmk_header *) buf_knl;

  memcpy (p_knl_data->sbml_codes, loader_code, SIZE_OF_MBR);

  lseek( devd, 0, SEEK_SET );
  if( read( devd, p_knl_data->previous_mbr, SECTOR_SIZE ) != SECTOR_SIZE )
    die ("read %s: %s", inst_dev, strerror (errno));

  p_knl->kernel_sectors = (knl_tsize + 511) / SECTOR_SIZE;

  if (p_knl->kernel_sectors > MAX_KNL_SECTORS)
    die ("SBM is too big!");

  p_knl->kernel_addr1 = KNL_LBA;
  p_knl->kernel_sects1 = p_knl->kernel_sectors;
  p_knl->kernel_sects2 = 0;

  p_knl->checksum = 0;
  p_knl->checksum = calc_checksum (buf_knl, p_knl->checksum_size);

  /* always begin at safe place */
  lseek (devd, SECTOR_SIZE * p_knl->kernel_addr1, SEEK_SET);
  if (write (devd, buf_knl, knl_tsize) != knl_tsize)
    die ("write %s: %s", inst_dev, strerror (errno));

  close_blk_dev (&devd);
}

void
proc_ldr ()
{
  int devd;

  devd = open_blk_dev (inst_dev);

  memcpy (buf_ldr, loader_code, LDR_SIZE);

  p_loader->kernel_sects1 = p_knl->kernel_sectors;
  p_loader->kernel_addr1 = KNL_LBA;
  p_loader->kernel_sects2 = 0;

  lseek (devd, 0, SEEK_SET);
  if (write (devd, buf_ldr, LDR_SIZE) != LDR_SIZE)
    die ("write %s: %s", inst_dev, strerror (errno));

  close_blk_dev (&devd);

}

void
install_main (char * themename, char * themesdir, char *drive, unsigned char drivenum)
{
  init_settings ();
  install_params (themename, themesdir, drive, drivenum);

  p_theme = (struct struc_sbmt_header *) theme_code;
  p_knl = (struct struc_sbmk_header *) main_code;
  p_loader = (struct struc_sbml_header *) buf_ldr;

  if (p_theme->magic != SBMT_MAGIC)
    die ("Invalid theme file!");
  if (p_theme->version != p_knl->version)
    die ("Theme version mismatched!");
  knl_tsize = p_knl->kernel_size + p_theme->size;
  if (p_theme->size > MAX_THEME_SIZE)
    die ("Theme file is too big!");

  proc_knl ();
  proc_ldr ();

  printf ("Installation successful!\n");
}

void emptybtmgr(struct struc_bootmanager *btmgr, char * themesdir, char * themename, 
		unsigned char drivenum, char *drive)
{
    install_params(themename, themesdir, "", drivenum);

    p_theme = (struct struc_sbmt_header *) theme_code;
    p_knl = (struct struc_sbmk_header *) main_code;
    p_loader = (struct struc_sbml_header *) buf_ldr;

    knl_tsize=p_knl->kernel_size;
    knl_tsize+=p_theme->size;

    memcpy(&(btmgr->sbmlheader), loader_code, sizeof(struct struc_sbml_header));

    btmgr->sbmlheader.kernel_addr1 = KNL_LBA;
    btmgr->sbmlheader.kernel_sects1 = (knl_tsize + 511) / SECTOR_SIZE;

    memcpy(&(btmgr->sbmkheader), main_code, sizeof(struct struc_sbmk_header));
    memcpy(&(btmgr->sbmkdata), main_code+sizeof(struct struc_sbmk_header), 
	   sizeof(struct struc_sbmk_data));

    btmgr->sbmkheader.kernel_addr1 = KNL_LBA;
    btmgr->sbmkheader.kernel_sects1 = btmgr->sbmlheader.kernel_sects1;
    btmgr->sbmkheader.kernel_sectors = btmgr->sbmlheader.kernel_sects1;

    btmgr->datalen = btmgr->sbmkheader.checksum_size;
    btmgr->data = malloc(sizeof(char)*btmgr->datalen+16);
    memcpy((char*)btmgr->data, main_code, btmgr->sbmkheader.kernel_size);
    memcpy((char*)btmgr->data + btmgr->sbmkheader.kernel_size, theme_code, btmgr->datalen - btmgr->sbmkheader.kernel_size);
}
