/*
*
*  A2DPD - Bluetooth A2DP daemon for Linux
*
*  Copyright (C) 2006-2007  Frédéric DALLEAU <frederic.dalleau@palmsource.com>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>

/*
int audio_mixer_16bits2(void *pcm_buffer, char **pcm_buffers, int nbuffers, int *pcm_buffers_size, int vol_left, int vol_right, int vol_max, int reverse_stereo)
{
}*/

int audio_mixer_16bits(void *pcm_buffer, char **pcm_buffers, int nbuffers, int *pcm_buffers_size, int vol_left, int vol_right, int vol_max, int reverse_stereo)
{
	int j;
	int max_buffer_size = 0;

#ifdef A2DPD_ENABLE_MIXER
	int i;
	int satured = 0;
#warning "mixer support enabled"
	for (j = 0; j < nbuffers; j++) {
		if(max_buffer_size < pcm_buffers_size[j])
			max_buffer_size = pcm_buffers_size[j];
	}

	// Mix audio streams 16 bits stereo channels
	// We require little endianness here
	for (j = 0; j < max_buffer_size / 4; j++) {
		int32_t *pBuffer = (int32_t *) pcm_buffer;
		int32_t channel_1 = 0;
		int32_t channel_2 = 0;
		for (i = 0; i < nbuffers; i++) {
			int32_t *pBuffers = (int32_t *) (pcm_buffers[i]);
			if (pBuffers != NULL && (j < pcm_buffers_size[i] / 4)) {
				int16_t i1 = *(((int16_t *) (pBuffers + j)) + 0);
				int16_t i2 = *(((int16_t *) (pBuffers + j)) + 1);
				channel_1 += i1;
				channel_2 += i2;
			}
		}
		//DBG("Value %08X|%08X %d|%d", channel_1, channel_2, channel_1, channel_2);
		// Stay within 16 bits per channel range
		if (channel_1 > +32767) {
			channel_1 = +32767;
			satured++;
		}
		if (channel_1 < -32768) {
			channel_1 = -32768;
			satured++;
		}

		if (channel_2 > +32767) {
			channel_2 = +32767;
			satured++;
		}
		if (channel_2 < -32768) {
			channel_2 = -32768;
			satured++;
		}

#ifdef A2DPD_ENABLE_VOL_CTL
#warning "volume control support enabled"
		channel_1 *= vol_left;
		channel_2 *= vol_right;
		channel_1 /= vol_max;
		channel_2 /= vol_max;
#else
#warning "volume control support disabled"
#endif

		if(reverse_stereo) {
			pBuffer[j] = (((channel_1 & 0x0000FFFF) << 16) | (channel_2 & 0x0000FFFF));
		} else {
			//FIXME We have a reverse stereo I don't know why
			// The following line corrects the problem but I miss the cause so be aware
			pBuffer[j] = (((channel_2 & 0x0000FFFF) << 16) | (channel_1 & 0x0000FFFF));
		}
	}
#else
#warning "mixer support disabled"
	// Take first buffer available
	for (j = 0; j < nbuffers; j++) {
		if(pcm_buffers_size[j] > 0) {
			memcpy(pcm_buffer, pcm_buffers[j], pcm_buffers_size[j]);
			max_buffer_size = pcm_buffers_size[j];
			break;
		}
	}
#endif
	return max_buffer_size;
}
