# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gui.aboutdialog import AboutDialog
from gui.extensionsconfig import ExtensionsConfig
from common.functions import Functions

from modules.explorer.views import Views
from modules.explorer import Explorer

class MainHandlers:
    def __init__(self, extensions, config, widgets, gst):
        self.extensions = extensions
        self.config = config
        self.widgets = widgets
        self.gst = gst
        self.functions = Functions()
        self.fullscreen = False

    def on_menu_fullscreen(self, widget):
        widget.set_active(not self.fullscreen)

        if self.fullscreen:
            self.widgets.get_widget('window1').unfullscreen()
        else:
            self.widgets.get_widget('window1').fullscreen()

        self.fullscreen = not self.fullscreen

    def on_menu_quit(self, widget):
        self.extensions.load_event('OnBluemindoQuitted')
        self.functions.close_bluemindo(self.widgets.get_widget('window1'))

    def on_window_close(self, widget, event):
        self.extensions.load_event('OnBluemindoWindowClosed')
        return True

    def on_tool_previous(self, widget):
        self.extensions.load_event('OnPreviousPressed')

    def on_tool_stop(self, widget):
        self.extensions.load_event('OnStopPressed')

    def on_tool_play(self, widget):
        self.extensions.load_event('OnPlayPressed')

    def on_tool_next(self, widget):
        self.extensions.load_event('OnNextPressed')

    def on_tool_lyrics(self, widget):
        self.extensions.load_event('OnToolLyricsPressed')

    def on_tool_reloadlyrics(self, widget):
        self.extensions.load_event('OnToolReloadLyricsPressed')

    def on_tool_savelyrics(self, widget):
        self.extensions.load_event('OnToolSaveLyricsPressed')

    def on_menu_prefs(self, widget):
        ExtensionsConfig(self.extensions)

    def on_menu_refresh(self, widget):
        config = Explorer(self.extensions).get_configuration()
        views = Views(glade_file=self.widgets, conf=config, force_reload=True)

    def on_menu_about(self, widget):
        AboutDialog()