# -*- coding: utf-8 -*-

#  Bluemindo
#  config.py

#    Bluemindo: A really simple but powerful audio player in Python/PyGTK.
#    Copyright (C) 2007-2008  Erwan Briand

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation version 3 of the License.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from os.path import join, isdir, expanduser
from os import listdir, makedirs
from os import environ
import ConfigParser

class ConfigLoader(object): 	     
    def __init__(self): 
        self.config = ConfigParser.ConfigParser()

        # Set the configuration directory to XDG_CONFIG_HOME if exists
        # If not, set it to $HOME/.config/bluemindo
        # http://standards.freedesktop.org/basedir-spec/basedir-spec-0.6.html
        if environ.get('XDG_CONFIG_HOME'):
            self.confdir = join(environ.get('XDG_CONFIG_HOME'), 'bluemindo')
        else:
            self.confdir = join(expanduser('~'), '.config', 'bluemindo')

        if not isdir(self.confdir):
            makedirs(self.confdir)

        # Set the data directory to XDG_DATA_HOME if exists
        # If not, set it to $HOME/.local/share/bluemindo
        # http://standards.freedesktop.org/basedir-spec/basedir-spec-0.6.html
        if environ.get('XDG_DATA_HOME'):
            self.datadir = join(environ.get('XDG_DATA_HOME'), 'bluemindo')
        else:
            self.datadir = join(expanduser('~'), '.local', 'share', 'bluemindo')

        if not isdir(self.datadir):
            makedirs(self.datadir)

