#!/usr/bin/perl
#
# This script reads BLD dump files and sends new additions to the WSFF
# RBL (http://dynamic.rfc1149.net/wsff).  It can be run from cron every
# 5 minutes.
#
# Olivier Beyssac <obld@r14.freenix.org>
#

use Net::SMTP;
use strict;

# Parameter to EHLO/HELO
my $helo = "CONFIGURE_THIS"; 

# SMTP host to connect to
my $smtp = "CONFIGURE_THIS";

# MAIL FROM and From: to use
my $from = "CONFIGURE\@THIS";

# How often we are run (seconds)
my $rate = 300;

# You can put what you want before the "@" if you prefer to have your
# own statistics on http://dynamic.rfc1149.net/wsff
# But I'd appreciate you mention BLD (eg "johndoe-bld\@kma.eu.org")
my $to = "bld\@kma.eu.org";

# Dump file to read
my $dump = "/var/run/bld/bld_blacklist.dump";

# Location of the state file.  This file is used to remember the last
# time we submitted an address.
my $state = "/var/run/wsff.state";
my $buffer;

if ($helo eq "CONFIGURE_THIS" || $smtp eq "CONFIGURE_THIS"
    || $from eq "CONFIGURE\@THIS") {
	print "You need to edit ".$ENV{"_"}." to set some parameters\n";
	exit(1);
}

my (undef, undef, undef, undef, undef, undef, undef,
    undef, undef, $mtime, undef, undef, undef) = stat($state);
if (!defined $mtime) {
	$mtime = time() - $rate;
}

open(BLD, "bldread $dump |");
while (<BLD>) {
	if (/^(\d+\.\d+\.\d+\.\d+);\d+;(\d+);/) {
		my $ip = $1;
		my $time = $2;
		if ($time > $mtime) {
			$buffer .= "$ip\n";
		}
	}
}
close(BLD);

open(STATE, "> $state") || die "Can't save state to $state";
close(STATE);

exit if (!defined $buffer);

my $smtp = Net::SMTP->new($smtp, Hello => $helo, Debug => 0)
	|| die "Unable to connect to $smtp";
$smtp->mail($from);
$smtp->to($to);
$smtp->data();
$smtp->datasend("From: $from\n");
$smtp->datasend("To: $to\n");
$smtp->datasend("\n");
$smtp->datasend($buffer);
$smtp->dataend();
$smtp->quit;
