

import smiles
from time import time


def test( function, times):
    t1 = time()
    for i in range( times):
        function()
    return time() - t1

def test_method( obj, method, args, times):
    t1 = time()
    for i in range( times):
        getattr( obj, method)( *args)
    return time() - t1



def is_edge_a_bridge_speed():
    mol = smiles.text_to_mol( "CCCC(CCC)CCCC1CC2CC1C2")
    t1 = time()
    for i in range( 100):
        b = 0
        for e in mol.edges:
            b += mol.is_edge_a_bridge( e)
    print b
    return time() - t1


sssr_smiles = "C1CC2CC1CC2"

def sssr_old():
    mol = smiles.text_to_mol( sssr_smiles)
    t1 = time()
    cs = mol.get_smallest_independent_cycles_e()
    print len( cs)
    return time() - t1

def sssr():
    mol = smiles.text_to_mol( sssr_smiles)
    t1 = time()
    cs = mol.get_smallest_independent_cycles_e_new()
    print len( cs)
    return time() - t1

    


def find_all_cycles_speed():
    pass


print "new", sssr()
print "old", sssr_old()
#print is_edge_a_bridge_speed()




