import inchi_key
import sys
import time

f = file( sys.argv[1], "r")
i = 0
t = time.time()
failed = 0
for line in f:
  if line.startswith( "InChI="):
    inchi = line.strip()
  elif line.startswith( "InChIKey="):
    i += 1
    key = line.strip()
    key2 = inchi_key.key_from_inchi( inchi)
    if key != key2:
      print i, key, key2, inchi
      failed += 1
    if not i % 100000:
      print "%d (failed %d)" % (i, failed)

f.close()
duration = time.time()-t

print "checked", i, "inchis", failed, "failed"
print "time: %.2f" % duration
print "%.1f keys per second" % (i/duration)
print "%.2fms per key" % (1000*duration/i)
