#--------------------------------------------------------------------------
#     This file is part of OASA - a free chemical python library
#     Copyright (C) 2005 Beda Kosata <beda@zirael.org>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file gpl.txt in the
#     main directory of the program

#--------------------------------------------------------------------------

import smiles


class substructure_search_manager( object):

  def __init__( self):
    self.structures = []

  def read_structure_file( self, name="sub_search_data.txt"):
    f = file( name, "r")
    for line in f:
      l = line.strip()
      if not l.startswith( "#"):
        parts = l.split(";")
        if len( parts) < 2:
          raise ValueError( "wrong line in data file: '%s'" % l)
        
  
  

class substructure( object):

  def __init__( self, name, compound_type, smiles="", significant_atoms=None):
    self.name = name
    self.compound_type = compound_type
    self.structure = None
    if smiles:
      self.read_smiles( smiles, significant_atoms=significant_atoms)

  def read_smiles( self, smiles_string, significant_atoms=None):
    self.significant_atoms = significant_atoms
    self.structure = smiles.text_to_mol( smiles_string)

  
