/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-26 20:09
 */

#ifndef UDPTRACKER_H_
#define UDPTRACKER_H_

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string>
#include "BitStorm.h"
#include "Socket.h"

class CUDPTracker :
	public ITracker,
	public CSocket
{
public:
	CUDPTracker();
	virtual ~CUDPTracker();
private:
	ITrackerManager* _trackerManager;
	std::string _url;
	
	TTrackerState _state;
	std::string _stateStr;	
	
	unsigned int _completePeer;
	unsigned int _totalPeer;
	unsigned int _interval;
	unsigned int _nextUpdateTick;
	
	int _currentEvent;
	bool _startEventSend;
	bool _completeEventSend;
	
	struct sockaddr_in _serverAddr;
	unsigned int _transID;
	int64_t _connectionID;
private:
	void sendConnectPacket();	
	void sendAnnouncPacket();	
	void processPkg(unsigned int actionID, char* data, size_t len);
	int getCurrentEvent();
public:
	void setTrackerManager(ITrackerManager* trackerManager);
	bool isProtocolSupported(const char* protocolName);
	void setUrl(const char* url);
	void update();
	void stop();
	TTrackerState getState();
	const std::string& getStateStr();
	unsigned int getSeedCount();
	unsigned int getPeerCount();
	unsigned int getInterval();
	unsigned int getNextUpdateTick();	
	
	int handleRead();
	int handleWrite();
	void handleClose();		
};

#endif /*UDPTRACKER_H_*/
